/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaderDecider;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.MetricsCollectingTaskDecorator;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTask;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import org.apache.flink.kinesis.shaded.org.apache.commons.lang3.Validate;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.Log;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.LogFactory;

class PeriodicShardSyncManager {
    private static final Log LOG = LogFactory.getLog(PeriodicShardSyncManager.class);
    private static final long INITIAL_DELAY = 0L;
    private static final long PERIODIC_SHARD_SYNC_INTERVAL_MILLIS = 1000L;
    private final String workerId;
    private final LeaderDecider leaderDecider;
    private final ITask metricsEmittingShardSyncTask;
    private final ScheduledExecutorService shardSyncThreadPool;
    private boolean isRunning;

    PeriodicShardSyncManager(String workerId, LeaderDecider leaderDecider, ShardSyncTask shardSyncTask, IMetricsFactory metricsFactory) {
        this(workerId, leaderDecider, shardSyncTask, Executors.newSingleThreadScheduledExecutor(), metricsFactory);
    }

    PeriodicShardSyncManager(String workerId, LeaderDecider leaderDecider, ShardSyncTask shardSyncTask, ScheduledExecutorService shardSyncThreadPool, IMetricsFactory metricsFactory) {
        Validate.notBlank(workerId, "WorkerID is required to initialize PeriodicShardSyncManager.", new Object[0]);
        Validate.notNull(leaderDecider, "LeaderDecider is required to initialize PeriodicShardSyncManager.", new Object[0]);
        Validate.notNull(shardSyncTask, "ShardSyncTask is required to initialize PeriodicShardSyncManager.", new Object[0]);
        this.workerId = workerId;
        this.leaderDecider = leaderDecider;
        this.metricsEmittingShardSyncTask = new MetricsCollectingTaskDecorator(shardSyncTask, metricsFactory);
        this.shardSyncThreadPool = shardSyncThreadPool;
    }

    public synchronized TaskResult start() {
        if (!this.isRunning) {
            this.shardSyncThreadPool.scheduleWithFixedDelay(this::runShardSync, 0L, 1000L, TimeUnit.MILLISECONDS);
            this.isRunning = true;
        }
        return new TaskResult(null);
    }

    public void stop() {
        if (this.isRunning) {
            LOG.info(String.format("Shutting down leader decider on worker %s", this.workerId));
            this.leaderDecider.shutdown();
            LOG.info(String.format("Shutting down periodic shard sync task scheduler on worker %s", this.workerId));
            this.shardSyncThreadPool.shutdown();
            this.isRunning = false;
        }
    }

    private void runShardSync() {
        try {
            if (this.leaderDecider.isLeader(this.workerId).booleanValue()) {
                LOG.debug(String.format("WorkerId %s is a leader, running the shard sync task", this.workerId));
                this.metricsEmittingShardSyncTask.call();
            } else {
                LOG.debug(String.format("WorkerId %s is not a leader, not running the shard sync task", this.workerId));
            }
        }
        catch (Throwable t) {
            LOG.error("Error during runShardSync.", t);
        }
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public LeaderDecider getLeaderDecider() {
        return this.leaderDecider;
    }

    public ITask getMetricsEmittingShardSyncTask() {
        return this.metricsEmittingShardSyncTask;
    }

    public ScheduledExecutorService getShardSyncThreadPool() {
        return this.shardSyncThreadPool;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PeriodicShardSyncManager)) {
            return false;
        }
        PeriodicShardSyncManager other = (PeriodicShardSyncManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$workerId = this.getWorkerId();
        String other$workerId = other.getWorkerId();
        if (this$workerId == null ? other$workerId != null : !this$workerId.equals(other$workerId)) {
            return false;
        }
        LeaderDecider this$leaderDecider = this.getLeaderDecider();
        LeaderDecider other$leaderDecider = other.getLeaderDecider();
        if (this$leaderDecider == null ? other$leaderDecider != null : !this$leaderDecider.equals(other$leaderDecider)) {
            return false;
        }
        ITask this$metricsEmittingShardSyncTask = this.getMetricsEmittingShardSyncTask();
        ITask other$metricsEmittingShardSyncTask = other.getMetricsEmittingShardSyncTask();
        if (this$metricsEmittingShardSyncTask == null ? other$metricsEmittingShardSyncTask != null : !this$metricsEmittingShardSyncTask.equals(other$metricsEmittingShardSyncTask)) {
            return false;
        }
        ScheduledExecutorService this$shardSyncThreadPool = this.getShardSyncThreadPool();
        ScheduledExecutorService other$shardSyncThreadPool = other.getShardSyncThreadPool();
        if (this$shardSyncThreadPool == null ? other$shardSyncThreadPool != null : !this$shardSyncThreadPool.equals(other$shardSyncThreadPool)) {
            return false;
        }
        return this.isRunning() == other.isRunning();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PeriodicShardSyncManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $workerId = this.getWorkerId();
        result = result * 59 + ($workerId == null ? 43 : $workerId.hashCode());
        LeaderDecider $leaderDecider = this.getLeaderDecider();
        result = result * 59 + ($leaderDecider == null ? 43 : $leaderDecider.hashCode());
        ITask $metricsEmittingShardSyncTask = this.getMetricsEmittingShardSyncTask();
        result = result * 59 + ($metricsEmittingShardSyncTask == null ? 43 : $metricsEmittingShardSyncTask.hashCode());
        ScheduledExecutorService $shardSyncThreadPool = this.getShardSyncThreadPool();
        result = result * 59 + ($shardSyncThreadPool == null ? 43 : $shardSyncThreadPool.hashCode());
        result = result * 59 + (this.isRunning() ? 79 : 97);
        return result;
    }
}

