/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSink;
import org.apache.flink.streaming.connectors.kafka.table.KafkaDynamicSource;
import org.apache.flink.streaming.connectors.kafka.table.KafkaOptions;
import org.apache.flink.streaming.connectors.kafka.table.KafkaSinkSemantic;
import org.apache.flink.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;

@Internal
public class KafkaDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "kafka";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(KafkaOptions.PROPS_BOOTSTRAP_SERVERS);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FactoryUtil.FORMAT);
        options.add(KafkaOptions.KEY_FORMAT);
        options.add(KafkaOptions.KEY_FIELDS);
        options.add(KafkaOptions.KEY_FIELDS_PREFIX);
        options.add(KafkaOptions.VALUE_FORMAT);
        options.add(KafkaOptions.VALUE_FIELDS_INCLUDE);
        options.add(KafkaOptions.TOPIC);
        options.add(KafkaOptions.TOPIC_PATTERN);
        options.add(KafkaOptions.PROPS_GROUP_ID);
        options.add(KafkaOptions.SCAN_STARTUP_MODE);
        options.add(KafkaOptions.SCAN_STARTUP_SPECIFIC_OFFSETS);
        options.add(KafkaOptions.SCAN_TOPIC_PARTITION_DISCOVERY);
        options.add(KafkaOptions.SCAN_STARTUP_TIMESTAMP_MILLIS);
        options.add(KafkaOptions.SINK_PARTITIONER);
        options.add(KafkaOptions.SINK_SEMANTIC);
        options.add(FactoryUtil.SINK_PARALLELISM);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        Optional<DecodingFormat<DeserializationSchema<RowData>>> keyDecodingFormat = KafkaDynamicTableFactory.getKeyDecodingFormat(helper);
        DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat = KafkaDynamicTableFactory.getValueDecodingFormat(helper);
        helper.validateExcept(new String[]{"properties."});
        KafkaOptions.validateTableSourceOptions(tableOptions);
        KafkaDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), (CatalogTable)context.getCatalogTable(), valueDecodingFormat);
        KafkaOptions.StartupOptions startupOptions = KafkaOptions.getStartupOptions(tableOptions);
        Properties properties = KafkaOptions.getKafkaProperties(context.getCatalogTable().getOptions());
        properties.setProperty("flink.partition-discovery.interval-millis", String.valueOf(tableOptions.getOptional(KafkaOptions.SCAN_TOPIC_PARTITION_DISCOVERY).map(Duration::toMillis).orElse(Long.MIN_VALUE)));
        DataType physicalDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        int[] keyProjection = KafkaOptions.createKeyFormatProjection(tableOptions, physicalDataType);
        int[] valueProjection = KafkaOptions.createValueFormatProjection(tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(KafkaOptions.KEY_FIELDS_PREFIX).orElse(null);
        return this.createKafkaTableSource(physicalDataType, (DecodingFormat<DeserializationSchema<RowData>>)((DecodingFormat)keyDecodingFormat.orElse(null)), valueDecodingFormat, keyProjection, valueProjection, keyPrefix, KafkaOptions.getSourceTopics(tableOptions), KafkaOptions.getSourceTopicPattern(tableOptions), properties, startupOptions.startupMode, startupOptions.specificOffsets, startupOptions.startupTimestampMillis);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)KafkaOptions.autoCompleteSchemaRegistrySubject(context));
        ReadableConfig tableOptions = helper.getOptions();
        Optional<EncodingFormat<SerializationSchema<RowData>>> keyEncodingFormat = KafkaDynamicTableFactory.getKeyEncodingFormat(helper);
        EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat = KafkaDynamicTableFactory.getValueEncodingFormat(helper);
        helper.validateExcept(new String[]{"properties."});
        KafkaOptions.validateTableSinkOptions(tableOptions);
        KafkaDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), (CatalogTable)context.getCatalogTable(), valueEncodingFormat);
        DataType physicalDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        int[] keyProjection = KafkaOptions.createKeyFormatProjection(tableOptions, physicalDataType);
        int[] valueProjection = KafkaOptions.createValueFormatProjection(tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(KafkaOptions.KEY_FIELDS_PREFIX).orElse(null);
        Integer parallelism = tableOptions.getOptional(FactoryUtil.SINK_PARALLELISM).orElse(null);
        return this.createKafkaTableSink(physicalDataType, (EncodingFormat<SerializationSchema<RowData>>)((EncodingFormat)keyEncodingFormat.orElse(null)), valueEncodingFormat, keyProjection, valueProjection, keyPrefix, (String)((List)tableOptions.get(KafkaOptions.TOPIC)).get(0), KafkaOptions.getKafkaProperties(context.getCatalogTable().getOptions()), KafkaOptions.getFlinkKafkaPartitioner(tableOptions, context.getClassLoader()).orElse(null), KafkaOptions.getSinkSemantic(tableOptions), parallelism);
    }

    private static Optional<DecodingFormat<DeserializationSchema<RowData>>> getKeyDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyDecodingFormat = helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, KafkaOptions.KEY_FORMAT);
        keyDecodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(KafkaOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyDecodingFormat;
    }

    private static Optional<EncodingFormat<SerializationSchema<RowData>>> getKeyEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyEncodingFormat = helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, KafkaOptions.KEY_FORMAT);
        keyEncodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(KafkaOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyEncodingFormat;
    }

    private static DecodingFormat<DeserializationSchema<RowData>> getValueDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverDecodingFormat(DeserializationFormatFactory.class, KafkaOptions.VALUE_FORMAT));
    }

    private static EncodingFormat<SerializationSchema<RowData>> getValueEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverEncodingFormat(SerializationFormatFactory.class, KafkaOptions.VALUE_FORMAT));
    }

    private static void validatePKConstraints(ObjectIdentifier tableName, CatalogTable catalogTable, Format format) {
        if (catalogTable.getSchema().getPrimaryKey().isPresent() && format.getChangelogMode().containsOnly(RowKind.INSERT)) {
            Configuration options = Configuration.fromMap((Map)catalogTable.getOptions());
            String formatName = (String)options.getOptional(FactoryUtil.FORMAT).orElse(options.get(KafkaOptions.VALUE_FORMAT));
            throw new ValidationException(String.format("The Kafka table '%s' with '%s' format doesn't support defining PRIMARY KEY constraint on the table, because it can't guarantee the semantic of primary key.", tableName.asSummaryString(), formatName));
        }
    }

    protected KafkaDynamicSource createKafkaTableSource(DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable List<String> topics, @Nullable Pattern topicPattern, Properties properties, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets, long startupTimestampMillis) {
        return new KafkaDynamicSource(physicalDataType, keyDecodingFormat, valueDecodingFormat, keyProjection, valueProjection, keyPrefix, topics, topicPattern, properties, startupMode, specificStartupOffsets, startupTimestampMillis, false);
    }

    protected KafkaDynamicSink createKafkaTableSink(DataType physicalDataType, @Nullable EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, String topic, Properties properties, FlinkKafkaPartitioner<RowData> partitioner, KafkaSinkSemantic semantic, Integer parallelism) {
        return new KafkaDynamicSink(physicalDataType, physicalDataType, keyEncodingFormat, valueEncodingFormat, keyProjection, valueProjection, keyPrefix, topic, properties, partitioner, semantic, false, SinkBufferFlushMode.DISABLED, parallelism);
    }
}

