/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.CollectionUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.FlattenedIterator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.MappedIterator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class StopReplicaRequest
extends AbstractControlRequest {
    private final StopReplicaRequestData data;

    private StopReplicaRequest(StopReplicaRequestData data, short version) {
        super(ApiKeys.STOP_REPLICA, version);
        this.data = data;
    }

    public StopReplicaRequest(Struct struct, short version) {
        this(new StopReplicaRequestData(struct, version), version);
    }

    @Override
    public StopReplicaResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        StopReplicaResponseData data = new StopReplicaResponseData();
        data.setErrorCode(error.code());
        ArrayList<StopReplicaResponseData.StopReplicaPartitionError> partitions = new ArrayList<StopReplicaResponseData.StopReplicaPartitionError>();
        for (TopicPartition tp : this.partitions()) {
            partitions.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setErrorCode(error.code()));
        }
        data.setPartitionErrors(partitions);
        return new StopReplicaResponse(data);
    }

    public boolean deletePartitions() {
        return this.data.deletePartitions();
    }

    public Iterable<TopicPartition> partitions() {
        if (this.version() >= 1) {
            return () -> new FlattenedIterator(this.data.topics().iterator(), topic -> new MappedIterator<Integer, TopicPartition>(topic.partitionIndexes().iterator(), partition -> new TopicPartition(topic.name(), (int)partition)));
        }
        return () -> new MappedIterator<StopReplicaRequestData.StopReplicaPartitionV0, TopicPartition>(this.data.ungroupedPartitions().iterator(), partition -> new TopicPartition(partition.topicName(), partition.partitionIndex()));
    }

    @Override
    public int controllerId() {
        return this.data.controllerId();
    }

    @Override
    public int controllerEpoch() {
        return this.data.controllerEpoch();
    }

    @Override
    public long brokerEpoch() {
        return this.data.brokerEpoch();
    }

    public static StopReplicaRequest parse(ByteBuffer buffer, short version) {
        return new StopReplicaRequest(ApiKeys.STOP_REPLICA.parseRequest(version, buffer), version);
    }

    StopReplicaRequestData data() {
        return this.data;
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractControlRequest.Builder<StopReplicaRequest> {
        private final boolean deletePartitions;
        private final Collection<TopicPartition> partitions;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, boolean deletePartitions, Collection<TopicPartition> partitions) {
            super(ApiKeys.STOP_REPLICA, version, controllerId, controllerEpoch, brokerEpoch);
            this.deletePartitions = deletePartitions;
            this.partitions = partitions;
        }

        @Override
        public StopReplicaRequest build(short version) {
            StopReplicaRequestData data = new StopReplicaRequestData().setControllerId(this.controllerId).setControllerEpoch(this.controllerEpoch).setBrokerEpoch(this.brokerEpoch).setDeletePartitions(this.deletePartitions);
            if (version >= 1) {
                Map<String, List<Integer>> topicPartitionsMap = CollectionUtils.groupPartitionsByTopic(this.partitions);
                List<StopReplicaRequestData.StopReplicaTopic> topics = topicPartitionsMap.entrySet().stream().map(entry -> new StopReplicaRequestData.StopReplicaTopic().setName((String)entry.getKey()).setPartitionIndexes((List)entry.getValue())).collect(Collectors.toList());
                data.setTopics(topics);
            } else {
                List<StopReplicaRequestData.StopReplicaPartitionV0> requestPartitions = this.partitions.stream().map(tp -> new StopReplicaRequestData.StopReplicaPartitionV0().setTopicName(tp.topic()).setPartitionIndex(tp.partition())).collect(Collectors.toList());
                data.setUngroupedPartitions(requestPartitions);
            }
            return new StopReplicaRequest(data, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=StopReplicaRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", deletePartitions=").append(this.deletePartitions).append(", brokerEpoch=").append(this.brokerEpoch).append(", partitions=").append(Utils.join(this.partitions, ",")).append(")");
            return bld.toString();
        }
    }
}

