/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;

public class DeleteRecordsRequestData
implements ApiMessage {
    private List<DeleteRecordsTopic> topics;
    private int timeoutMs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public DeleteRecordsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DeleteRecordsRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public DeleteRecordsRequestData() {
        this.topics = new ArrayList<DeleteRecordsTopic>();
        this.timeoutMs = 0;
    }

    @Override
    public short apiKey() {
        return 21;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<DeleteRecordsTopic> newCollection = new ArrayList<DeleteRecordsTopic>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DeleteRecordsTopic(_readable, _version));
        }
        this.topics = newCollection;
        this.timeoutMs = _readable.readInt();
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.topics.size());
        for (DeleteRecordsTopic topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version);
        }
        _writable.writeInt(this.timeoutMs);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<DeleteRecordsTopic>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new DeleteRecordsTopic((Struct)nestedObject, _version));
        }
        this.timeoutMs = struct.getInt("timeout_ms");
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (DeleteRecordsTopic element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        for (DeleteRecordsTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        _size += 4;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteRecordsRequestData)) {
            return false;
        }
        DeleteRecordsRequestData other = (DeleteRecordsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return this.timeoutMs == other.timeoutMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    public String toString() {
        return "DeleteRecordsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<DeleteRecordsTopic> topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DeleteRecordsRequestData setTopics(List<DeleteRecordsTopic> v) {
        this.topics = v;
        return this;
    }

    public DeleteRecordsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(DeleteRecordsTopic.SCHEMA_0), "Each topic that we want to delete records from."), new Field("timeout_ms", Type.INT32, "How long to wait for the deletion to complete, in milliseconds."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class DeleteRecordsPartition
    implements Message {
        private int partitionIndex;
        private long offset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DeleteRecordsPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DeleteRecordsPartition(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public DeleteRecordsPartition() {
            this.partitionIndex = 0;
            this.offset = 0L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteRecordsPartition");
            }
            this.partitionIndex = _readable.readInt();
            this.offset = _readable.readLong();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteRecordsPartition");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeLong(this.offset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteRecordsPartition");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.offset = struct.getLong("offset");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteRecordsPartition");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("offset", (Object)this.offset);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteRecordsPartition");
            }
            _size += 4;
            _size += 8;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteRecordsPartition)) {
                return false;
            }
            DeleteRecordsPartition other = (DeleteRecordsPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return this.offset == other.offset;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            return hashCode;
        }

        public String toString() {
            return "DeleteRecordsPartition(partitionIndex=" + this.partitionIndex + ", offset=" + this.offset + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long offset() {
            return this.offset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteRecordsPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public DeleteRecordsPartition setOffset(long v) {
            this.offset = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("offset", Type.INT64, "The deletion offset."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class DeleteRecordsTopic
    implements Message {
        private String name;
        private List<DeleteRecordsPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DeleteRecordsTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DeleteRecordsTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public DeleteRecordsTopic() {
            this.name = "";
            this.partitions = new ArrayList<DeleteRecordsPartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteRecordsTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<DeleteRecordsPartition> newCollection = new ArrayList<DeleteRecordsPartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new DeleteRecordsPartition(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteRecordsTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                DeleteRecordsPartition partitionsElement = (DeleteRecordsPartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DeleteRecordsTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<DeleteRecordsPartition>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new DeleteRecordsPartition((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DeleteRecordsTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (DeleteRecordsPartition element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DeleteRecordsTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (DeleteRecordsPartition partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteRecordsTopic)) {
                return false;
            }
            DeleteRecordsTopic other = (DeleteRecordsTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DeleteRecordsTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<DeleteRecordsPartition> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DeleteRecordsTopic setName(String v) {
            this.name = v;
            return this;
        }

        public DeleteRecordsTopic setPartitions(List<DeleteRecordsPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(DeleteRecordsPartition.SCHEMA_0), "Each partition that we want to delete records from."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

