/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ListGroupsResponse;

public class ListGroupsRequest
extends AbstractRequest {
    private final ListGroupsRequestData data;

    public ListGroupsRequest(ListGroupsRequestData data, short version) {
        super(ApiKeys.LIST_GROUPS, version);
        this.data = data;
    }

    public ListGroupsRequest(Struct struct, short version) {
        super(ApiKeys.LIST_GROUPS, version);
        this.data = new ListGroupsRequestData(struct, version);
    }

    @Override
    public ListGroupsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ListGroupsResponseData listGroupsResponseData = new ListGroupsResponseData().setGroups(Collections.emptyList()).setErrorCode(Errors.forException(e).code());
        if (this.version() >= 1) {
            listGroupsResponseData.setThrottleTimeMs(throttleTimeMs);
        }
        return new ListGroupsResponse(listGroupsResponseData);
    }

    public static ListGroupsRequest parse(ByteBuffer buffer, short version) {
        return new ListGroupsRequest(ApiKeys.LIST_GROUPS.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return this.data.toStruct(this.version());
    }

    public static class Builder
    extends AbstractRequest.Builder<ListGroupsRequest> {
        private final ListGroupsRequestData data;

        public Builder(ListGroupsRequestData data) {
            super(ApiKeys.LIST_GROUPS);
            this.data = data;
        }

        @Override
        public ListGroupsRequest build(short version) {
            return new ListGroupsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

