/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.acl.AclBinding;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ApiError;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.RequestUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.resource.PatternType;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.resource.ResourcePattern;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class CreateAclsRequest
extends AbstractRequest {
    private static final String CREATIONS_KEY_NAME = "creations";
    private static final Schema CREATE_ACLS_REQUEST_V0 = new Schema(new Field("creations", new ArrayOf(new Schema(CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME, CommonFields.PRINCIPAL, CommonFields.HOST, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE))));
    private static final Schema CREATE_ACLS_REQUEST_V1 = new Schema(new Field("creations", new ArrayOf(new Schema(CommonFields.RESOURCE_TYPE, CommonFields.RESOURCE_NAME, CommonFields.RESOURCE_PATTERN_TYPE, CommonFields.PRINCIPAL, CommonFields.HOST, CommonFields.OPERATION, CommonFields.PERMISSION_TYPE))));
    private final List<AclCreation> aclCreations;

    public static Schema[] schemaVersions() {
        return new Schema[]{CREATE_ACLS_REQUEST_V0, CREATE_ACLS_REQUEST_V1};
    }

    CreateAclsRequest(short version, List<AclCreation> aclCreations) {
        super(ApiKeys.CREATE_ACLS, version);
        this.aclCreations = aclCreations;
        this.validate(aclCreations);
    }

    public CreateAclsRequest(Struct struct, short version) {
        super(ApiKeys.CREATE_ACLS, version);
        this.aclCreations = new ArrayList<AclCreation>();
        for (Object creationStructObj : struct.getArray(CREATIONS_KEY_NAME)) {
            Struct creationStruct = (Struct)creationStructObj;
            this.aclCreations.add(AclCreation.fromStruct(creationStruct));
        }
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.CREATE_ACLS.requestSchema(this.version()));
        ArrayList<Struct> requests = new ArrayList<Struct>();
        for (AclCreation creation : this.aclCreations) {
            Struct creationStruct = struct.instance(CREATIONS_KEY_NAME);
            creation.setStructFields(creationStruct);
            requests.add(creationStruct);
        }
        struct.set(CREATIONS_KEY_NAME, (Object)requests.toArray());
        return struct;
    }

    public List<AclCreation> aclCreations() {
        return this.aclCreations;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable throwable) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                ArrayList<CreateAclsResponse.AclCreationResponse> responses = new ArrayList<CreateAclsResponse.AclCreationResponse>();
                for (int i = 0; i < this.aclCreations.size(); ++i) {
                    responses.add(new CreateAclsResponse.AclCreationResponse(ApiError.fromThrowable(throwable)));
                }
                return new CreateAclsResponse(throttleTimeMs, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.CREATE_ACLS.latestVersion()));
    }

    public static CreateAclsRequest parse(ByteBuffer buffer, short version) {
        return new CreateAclsRequest(ApiKeys.CREATE_ACLS.parseRequest(version, buffer), version);
    }

    private void validate(List<AclCreation> aclCreations) {
        boolean unsupported;
        if (this.version() == 0 && (unsupported = aclCreations.stream().map(AclCreation::acl).map(AclBinding::pattern).map(ResourcePattern::patternType).anyMatch(patternType -> patternType != PatternType.LITERAL))) {
            throw new UnsupportedVersionException("Version 0 only supports literal resource pattern types");
        }
        boolean unknown = aclCreations.stream().map(AclCreation::acl).anyMatch(AclBinding::isUnknown);
        if (unknown) {
            throw new IllegalArgumentException("You can not create ACL bindings with unknown elements");
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateAclsRequest> {
        private final List<AclCreation> creations;

        public Builder(List<AclCreation> creations) {
            super(ApiKeys.CREATE_ACLS);
            this.creations = creations;
        }

        @Override
        public CreateAclsRequest build(short version) {
            return new CreateAclsRequest(version, this.creations);
        }

        public String toString() {
            return "(type=CreateAclsRequest, creations=" + Utils.join(this.creations, ", ") + ")";
        }
    }

    public static class AclCreation {
        private final AclBinding acl;

        public AclCreation(AclBinding acl) {
            this.acl = acl;
        }

        static AclCreation fromStruct(Struct struct) {
            ResourcePattern pattern = RequestUtils.resourcePatternromStructFields(struct);
            AccessControlEntry entry = RequestUtils.aceFromStructFields(struct);
            return new AclCreation(new AclBinding(pattern, entry));
        }

        public AclBinding acl() {
            return this.acl;
        }

        void setStructFields(Struct struct) {
            RequestUtils.resourcePatternSetStructFields(this.acl.pattern(), struct);
            RequestUtils.aceSetStructFields(this.acl.entry(), struct);
        }

        public String toString() {
            return "(acl=" + this.acl + ")";
        }
    }
}

