/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;

public class DescribeAclsResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private String errorMessage;
    private List<DescribeAclsResource> resources;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("resources", new ArrayOf(DescribeAclsResource.SCHEMA_0), "Each Resource that is referenced in an ACL."));
    public static final Schema SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("resources", new ArrayOf(DescribeAclsResource.SCHEMA_1), "Each Resource that is referenced in an ACL."));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

    public DescribeAclsResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public DescribeAclsResponseData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public DescribeAclsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.resources = new ArrayList<DescribeAclsResource>();
    }

    @Override
    public short apiKey() {
        return 29;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field resources was serialized as null");
        }
        ArrayList<DescribeAclsResource> newCollection = new ArrayList<DescribeAclsResource>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new DescribeAclsResource(_readable, _version));
        }
        this.resources = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.resources.size());
        _stringBytes = this.resources.iterator();
        while (_stringBytes.hasNext()) {
            DescribeAclsResource resourcesElement = (DescribeAclsResource)_stringBytes.next();
            resourcesElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.errorCode = struct.getShort("error_code");
        this.errorMessage = struct.getString("error_message");
        Object[] _nestedObjects = struct.getArray("resources");
        this.resources = new ArrayList<DescribeAclsResource>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.resources.add(new DescribeAclsResource((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set("error_code", (Object)this.errorCode);
        struct.set("error_message", (Object)this.errorMessage);
        Struct[] _nestedObjects = new Struct[this.resources.size()];
        int i = 0;
        for (DescribeAclsResource element : this.resources) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("resources", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        _size += 4;
        _size += 2;
        if (this.errorMessage == null) {
            _size += 2;
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size += _stringBytes.length + 2;
        }
        int _arraySize = 0;
        _arraySize += 4;
        for (DescribeAclsResource resourcesElement : this.resources) {
            _arraySize += resourcesElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeAclsResponseData)) {
            return false;
        }
        DescribeAclsResponseData other = (DescribeAclsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        return !(this.resources == null ? other.resources != null : !this.resources.equals(other.resources));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        return hashCode;
    }

    public String toString() {
        return "DescribeAclsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", resources=" + MessageUtil.deepToString(this.resources.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<DescribeAclsResource> resources() {
        return this.resources;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeAclsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeAclsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeAclsResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeAclsResponseData setResources(List<DescribeAclsResource> v) {
        this.resources = v;
        return this;
    }

    public static class AclDescription
    implements Message {
        private String principal;
        private String host;
        private byte operation;
        private byte permissionType;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AclDescription(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public AclDescription(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public AclDescription() {
            this.principal = "";
            this.host = "";
            this.operation = 0;
            this.permissionType = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AclDescription");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field principal was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field principal had invalid length " + length);
            }
            this.principal = _readable.readString(length);
            length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.operation = _readable.readByte();
            this.permissionType = _readable.readByte();
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AclDescription");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.principal);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            _writable.writeByte(this.operation);
            _writable.writeByte(this.permissionType);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AclDescription");
            }
            this._unknownTaggedFields = null;
            this.principal = struct.getString("principal");
            this.host = struct.getString("host");
            this.operation = struct.getByte("operation");
            this.permissionType = struct.getByte("permission_type");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AclDescription");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("principal", (Object)this.principal);
            struct.set("host", (Object)this.host);
            struct.set("operation", (Object)this.operation);
            struct.set("permission_type", (Object)this.permissionType);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AclDescription");
            }
            byte[] _stringBytes = this.principal.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'principal' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.principal, _stringBytes);
            _size += _stringBytes.length + 2;
            _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size += _stringBytes.length + 2;
            ++_size;
            ++_size;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AclDescription)) {
                return false;
            }
            AclDescription other = (AclDescription)obj;
            if (this.principal == null ? other.principal != null : !this.principal.equals(other.principal)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.operation != other.operation) {
                return false;
            }
            return this.permissionType == other.permissionType;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.principal == null ? 0 : this.principal.hashCode());
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.operation;
            hashCode = 31 * hashCode + this.permissionType;
            return hashCode;
        }

        public String toString() {
            return "AclDescription(principal=" + (this.principal == null ? "null" : "'" + this.principal.toString() + "'") + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", operation=" + this.operation + ", permissionType=" + this.permissionType + ")";
        }

        public String principal() {
            return this.principal;
        }

        public String host() {
            return this.host;
        }

        public byte operation() {
            return this.operation;
        }

        public byte permissionType() {
            return this.permissionType;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AclDescription setPrincipal(String v) {
            this.principal = v;
            return this;
        }

        public AclDescription setHost(String v) {
            this.host = v;
            return this;
        }

        public AclDescription setOperation(byte v) {
            this.operation = v;
            return this;
        }

        public AclDescription setPermissionType(byte v) {
            this.permissionType = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("principal", Type.STRING, "The ACL principal."), new Field("host", Type.STRING, "The ACL host."), new Field("operation", Type.INT8, "The ACL operation."), new Field("permission_type", Type.INT8, "The ACL permission type."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class DescribeAclsResource
    implements Message {
        private byte type;
        private String name;
        private byte patternType;
        private List<AclDescription> acls;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("type", Type.INT8, "The resource type."), new Field("name", Type.STRING, "The resource name."), new Field("acls", new ArrayOf(AclDescription.SCHEMA_0), "The ACLs."));
        public static final Schema SCHEMA_1 = new Schema(new Field("type", Type.INT8, "The resource type."), new Field("name", Type.STRING, "The resource name."), new Field("pattern_type", Type.INT8, "The resource pattern type."), new Field("acls", new ArrayOf(AclDescription.SCHEMA_0), "The ACLs."));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};

        public DescribeAclsResource(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public DescribeAclsResource(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public DescribeAclsResource() {
            this.type = 0;
            this.name = "";
            this.patternType = (byte)3;
            this.acls = new ArrayList<AclDescription>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeAclsResource");
            }
            this.type = _readable.readByte();
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.patternType = _version >= 1 ? _readable.readByte() : (byte)3;
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field acls was serialized as null");
            }
            ArrayList<AclDescription> newCollection = new ArrayList<AclDescription>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new AclDescription(_readable, _version));
            }
            this.acls = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribeAclsResource");
            }
            int _numTaggedFields = 0;
            _writable.writeByte(this.type);
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 1) {
                _writable.writeByte(this.patternType);
            } else if (this.patternType != 3) {
                throw new UnsupportedVersionException("Attempted to write a non-default patternType at version " + _version);
            }
            _writable.writeInt(this.acls.size());
            _stringBytes = this.acls.iterator();
            while (_stringBytes.hasNext()) {
                AclDescription aclsElement = (AclDescription)_stringBytes.next();
                aclsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of DescribeAclsResource");
            }
            this._unknownTaggedFields = null;
            this.type = struct.getByte("type");
            this.name = struct.getString("name");
            this.patternType = _version >= 1 ? struct.getByte("pattern_type") : (byte)3;
            Object[] _nestedObjects = struct.getArray("acls");
            this.acls = new ArrayList<AclDescription>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.acls.add(new AclDescription((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of DescribeAclsResource");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("type", (Object)this.type);
            struct.set("name", (Object)this.name);
            if (_version >= 1) {
                struct.set("pattern_type", (Object)this.patternType);
            }
            Struct[] _nestedObjects = new Struct[this.acls.size()];
            int i = 0;
            for (AclDescription element : this.acls) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("acls", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of DescribeAclsResource");
            }
            ++_size;
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            if (_version >= 1) {
                ++_size;
            }
            int _arraySize = 0;
            _arraySize += 4;
            for (AclDescription aclsElement : this.acls) {
                _arraySize += aclsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DescribeAclsResource)) {
                return false;
            }
            DescribeAclsResource other = (DescribeAclsResource)obj;
            if (this.type != other.type) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.patternType != other.patternType) {
                return false;
            }
            return !(this.acls == null ? other.acls != null : !this.acls.equals(other.acls));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.type;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + this.patternType;
            hashCode = 31 * hashCode + (this.acls == null ? 0 : this.acls.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DescribeAclsResource(type=" + this.type + ", name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", patternType=" + this.patternType + ", acls=" + MessageUtil.deepToString(this.acls.iterator()) + ")";
        }

        public byte type() {
            return this.type;
        }

        public String name() {
            return this.name;
        }

        public byte patternType() {
            return this.patternType;
        }

        public List<AclDescription> acls() {
            return this.acls;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public DescribeAclsResource setType(byte v) {
            this.type = v;
            return this;
        }

        public DescribeAclsResource setName(String v) {
            this.name = v;
            return this;
        }

        public DescribeAclsResource setPatternType(byte v) {
            this.patternType = v;
            return this;
        }

        public DescribeAclsResource setAcls(List<AclDescription> v) {
            this.acls = v;
            return this;
        }
    }
}

