/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.Metadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.MetadataRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.MetadataResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.LogContext;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;

public class ProducerMetadata
extends Metadata {
    private static final long TOPIC_EXPIRY_NEEDS_UPDATE = -1L;
    static final long TOPIC_EXPIRY_MS = 300000L;
    private final Map<String, Long> topics = new HashMap<String, Long>();
    private final Logger log;
    private final Time time;

    public ProducerMetadata(long refreshBackoffMs, long metadataExpireMs, LogContext logContext, ClusterResourceListeners clusterResourceListeners, Time time) {
        super(refreshBackoffMs, metadataExpireMs, logContext, clusterResourceListeners);
        this.log = logContext.logger(ProducerMetadata.class);
        this.time = time;
    }

    @Override
    public synchronized MetadataRequest.Builder newMetadataRequestBuilder() {
        return new MetadataRequest.Builder(new ArrayList<String>(this.topics.keySet()), true);
    }

    public synchronized void add(String topic) {
        Objects.requireNonNull(topic, "topic cannot be null");
        if (this.topics.put(topic, -1L) == null) {
            this.requestUpdateForNewTopics();
        }
    }

    synchronized Set<String> topics() {
        return this.topics.keySet();
    }

    public synchronized boolean containsTopic(String topic) {
        return this.topics.containsKey(topic);
    }

    @Override
    public synchronized boolean retainTopic(String topic, boolean isInternal, long nowMs) {
        Long expireMs = this.topics.get(topic);
        if (expireMs == null) {
            return false;
        }
        if (expireMs == -1L) {
            this.topics.put(topic, nowMs + 300000L);
            return true;
        }
        if (expireMs <= nowMs) {
            this.log.debug("Removing unused topic {} from the metadata list, expiryMs {} now {}", new Object[]{topic, expireMs, nowMs});
            this.topics.remove(topic);
            return false;
        }
        return true;
    }

    public synchronized void awaitUpdate(int lastVersion, long timeoutMs) throws InterruptedException {
        long currentTimeMs = this.time.milliseconds();
        long deadlineMs = currentTimeMs + timeoutMs < 0L ? Long.MAX_VALUE : currentTimeMs + timeoutMs;
        this.time.waitObject(this, () -> {
            this.maybeThrowFatalException();
            return this.updateVersion() > lastVersion || this.isClosed();
        }, deadlineMs);
        if (this.isClosed()) {
            throw new KafkaException("Requested metadata update after close");
        }
    }

    @Override
    public synchronized void update(int requestVersion, MetadataResponse response, long now) {
        super.update(requestVersion, response, now);
        this.notifyAll();
    }

    @Override
    public synchronized void fatalError(KafkaException fatalException) {
        super.fatalError(fatalException);
        this.notifyAll();
    }

    @Override
    public synchronized void close() {
        super.close();
        this.notifyAll();
    }
}

