/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.subscriber;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriber;
import org.apache.flink.connector.kafka.source.enumerator.subscriber.KafkaSubscriberUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.AdminClient;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.TopicDescription;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TopicPatternSubscriber
implements KafkaSubscriber {
    private static final long serialVersionUID = -7471048577725467797L;
    private static final Logger LOG = LoggerFactory.getLogger(TopicPatternSubscriber.class);
    private final Pattern topicPattern;

    TopicPatternSubscriber(Pattern topicPattern) {
        this.topicPattern = topicPattern;
    }

    @Override
    public KafkaSubscriber.PartitionChange getPartitionChanges(AdminClient adminClient, Set<TopicPartition> currentAssignment) {
        HashSet<TopicPartition> newPartitions = new HashSet<TopicPartition>();
        HashSet<TopicPartition> removedPartitions = new HashSet<TopicPartition>(currentAssignment);
        Map<String, TopicDescription> topicMetadata = KafkaSubscriberUtils.getTopicMetadata(adminClient);
        for (Map.Entry<String, TopicDescription> topicEntry : topicMetadata.entrySet()) {
            String topic = topicEntry.getKey();
            if (!this.topicPattern.matcher(topic).matches()) continue;
            KafkaSubscriberUtils.updatePartitionChanges(topic, newPartitions, removedPartitions, topicEntry.getValue().partitions());
        }
        KafkaSubscriberUtils.maybeLog(newPartitions, removedPartitions, LOG);
        return new KafkaSubscriber.PartitionChange(newPartitions, removedPartitions);
    }
}

