/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.enumerator.initializer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.kafka.source.enumerator.initializer.OffsetsInitializer;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;

class ReaderHandledOffsetsInitializer
implements OffsetsInitializer {
    private static final long serialVersionUID = 172938052008787981L;
    private final long startingOffset;
    private final OffsetResetStrategy offsetResetStrategy;

    ReaderHandledOffsetsInitializer(long startingOffset, OffsetResetStrategy offsetResetStrategy) {
        this.startingOffset = startingOffset;
        this.offsetResetStrategy = offsetResetStrategy;
    }

    @Override
    public Map<TopicPartition, Long> getPartitionOffsets(Collection<TopicPartition> partitions, OffsetsInitializer.PartitionOffsetsRetriever partitionOffsetsRetriever) {
        HashMap<TopicPartition, Long> initialOffsets = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : partitions) {
            initialOffsets.put(tp, this.startingOffset);
        }
        return initialOffsets;
    }

    @Override
    public OffsetResetStrategy getAutoOffsetResetStrategy() {
        return this.offsetResetStrategy;
    }
}

