/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.security.scram.internals;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class ScramExtensions {
    private final Map<String, String> extensionMap;

    public ScramExtensions() {
        this(Collections.emptyMap());
    }

    public ScramExtensions(String extensions) {
        this(Utils.parseMap(extensions, "=", ","));
    }

    public ScramExtensions(Map<String, String> extensionMap) {
        this.extensionMap = extensionMap;
    }

    public String extensionValue(String name) {
        return this.extensionMap.get(name);
    }

    public Set<String> extensionNames() {
        return this.extensionMap.keySet();
    }

    public boolean tokenAuthenticated() {
        return Boolean.parseBoolean(this.extensionMap.get("tokenauth"));
    }

    public String toString() {
        return Utils.mkString(this.extensionMap, "", "", "=", ",");
    }
}

