/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class SaslHandshakeResponse
extends AbstractResponse {
    private static final String ENABLED_MECHANISMS_KEY_NAME = "enabled_mechanisms";
    private static final Schema SASL_HANDSHAKE_RESPONSE_V0;
    private static final Schema SASL_HANDSHAKE_RESPONSE_V1;
    private final Errors error;
    private final List<String> enabledMechanisms;

    public static Schema[] schemaVersions() {
        return new Schema[]{SASL_HANDSHAKE_RESPONSE_V0, SASL_HANDSHAKE_RESPONSE_V1};
    }

    public SaslHandshakeResponse(Errors error, Collection<String> enabledMechanisms) {
        this.error = error;
        this.enabledMechanisms = new ArrayList<String>(enabledMechanisms);
    }

    public SaslHandshakeResponse(Struct struct) {
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        Object[] mechanisms = struct.getArray(ENABLED_MECHANISMS_KEY_NAME);
        ArrayList<String> enabledMechanisms = new ArrayList<String>();
        for (Object mechanism : mechanisms) {
            enabledMechanisms.add((String)mechanism);
        }
        this.enabledMechanisms = enabledMechanisms;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.SASL_HANDSHAKE.responseSchema(version));
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        struct.set(ENABLED_MECHANISMS_KEY_NAME, (Object)this.enabledMechanisms.toArray());
        return struct;
    }

    public List<String> enabledMechanisms() {
        return this.enabledMechanisms;
    }

    public static SaslHandshakeResponse parse(ByteBuffer buffer, short version) {
        return new SaslHandshakeResponse(ApiKeys.SASL_HANDSHAKE.parseResponse(version, buffer));
    }

    static {
        SASL_HANDSHAKE_RESPONSE_V1 = SASL_HANDSHAKE_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field(ENABLED_MECHANISMS_KEY_NAME, new ArrayOf(Type.STRING), "Array of mechanisms enabled in the server."));
    }
}

