/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.CommonFields;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class OffsetsForLeaderEpochResponse
extends AbstractResponse {
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String END_OFFSET_KEY_NAME = "end_offset";
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_PARTITION_V0 = new Schema(CommonFields.ERROR_CODE, CommonFields.PARTITION_ID, new Field("end_offset", Type.INT64, "The end offset"));
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(OFFSET_FOR_LEADER_EPOCH_RESPONSE_PARTITION_V0)));
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_V0 = new Schema(new Field("topics", new ArrayOf(OFFSET_FOR_LEADER_EPOCH_RESPONSE_TOPIC_V0), "An array of topics for which we have leader offsets for some requested Partition Leader Epoch"));
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_PARTITION_V1 = new Schema(CommonFields.ERROR_CODE, CommonFields.PARTITION_ID, CommonFields.LEADER_EPOCH, new Field("end_offset", Type.INT64, "The end offset"));
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_TOPIC_V1 = new Schema(CommonFields.TOPIC_NAME, new Field("partitions", new ArrayOf(OFFSET_FOR_LEADER_EPOCH_RESPONSE_PARTITION_V1)));
    private static final Schema OFFSET_FOR_LEADER_EPOCH_RESPONSE_V1 = new Schema(new Field("topics", new ArrayOf(OFFSET_FOR_LEADER_EPOCH_RESPONSE_TOPIC_V1), "An array of topics for which we have leader offsets for some requested Partition Leader Epoch"));
    private Map<TopicPartition, EpochEndOffset> epochEndOffsetsByPartition;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_FOR_LEADER_EPOCH_RESPONSE_V0, OFFSET_FOR_LEADER_EPOCH_RESPONSE_V1};
    }

    public OffsetsForLeaderEpochResponse(Struct struct) {
        this.epochEndOffsetsByPartition = new HashMap<TopicPartition, EpochEndOffset>();
        for (Object topicAndEpocsObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicAndEpochs = (Struct)topicAndEpocsObj;
            String topic = topicAndEpochs.get(CommonFields.TOPIC_NAME);
            for (Object partitionAndEpochObj : topicAndEpochs.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionAndEpoch = (Struct)partitionAndEpochObj;
                Errors error = Errors.forCode(partitionAndEpoch.get(CommonFields.ERROR_CODE));
                int partitionId = partitionAndEpoch.get(CommonFields.PARTITION_ID);
                TopicPartition tp = new TopicPartition(topic, partitionId);
                int leaderEpoch = partitionAndEpoch.getOrElse(CommonFields.LEADER_EPOCH, -1);
                long endOffset = partitionAndEpoch.getLong(END_OFFSET_KEY_NAME);
                this.epochEndOffsetsByPartition.put(tp, new EpochEndOffset(error, leaderEpoch, endOffset));
            }
        }
    }

    public OffsetsForLeaderEpochResponse(Map<TopicPartition, EpochEndOffset> epochsByTopic) {
        this.epochEndOffsetsByPartition = epochsByTopic;
    }

    public Map<TopicPartition, EpochEndOffset> responses() {
        return this.epochEndOffsetsByPartition;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (EpochEndOffset response : this.epochEndOffsetsByPartition.values()) {
            this.updateErrorCounts(errorCounts, response.error());
        }
        return errorCounts;
    }

    public static OffsetsForLeaderEpochResponse parse(ByteBuffer buffer, short versionId) {
        return new OffsetsForLeaderEpochResponse(ApiKeys.OFFSET_FOR_LEADER_EPOCH.responseSchema(versionId).read(buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct responseStruct = new Struct(ApiKeys.OFFSET_FOR_LEADER_EPOCH.responseSchema(version));
        Map<String, Map<Integer, EpochEndOffset>> endOffsetsByTopic = CollectionUtils.groupDataByTopic(this.epochEndOffsetsByPartition);
        ArrayList<Struct> topics = new ArrayList<Struct>(endOffsetsByTopic.size());
        for (Map.Entry<String, Map<Integer, EpochEndOffset>> topicToPartitionEpochs : endOffsetsByTopic.entrySet()) {
            Struct topicStruct = responseStruct.instance(TOPICS_KEY_NAME);
            topicStruct.set(CommonFields.TOPIC_NAME, topicToPartitionEpochs.getKey());
            Map<Integer, EpochEndOffset> partitionEpochs = topicToPartitionEpochs.getValue();
            ArrayList<Struct> partitions = new ArrayList<Struct>();
            for (Map.Entry<Integer, EpochEndOffset> partitionEndOffset : partitionEpochs.entrySet()) {
                Struct partitionStruct = topicStruct.instance(PARTITIONS_KEY_NAME);
                partitionStruct.set(CommonFields.ERROR_CODE, partitionEndOffset.getValue().error().code());
                partitionStruct.set(CommonFields.PARTITION_ID, partitionEndOffset.getKey());
                partitionStruct.setIfExists(CommonFields.LEADER_EPOCH, (Object)partitionEndOffset.getValue().leaderEpoch());
                partitionStruct.set(END_OFFSET_KEY_NAME, (Object)partitionEndOffset.getValue().endOffset());
                partitions.add(partitionStruct);
            }
            topicStruct.set(PARTITIONS_KEY_NAME, (Object)partitions.toArray());
            topics.add(topicStruct);
        }
        responseStruct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        return responseStruct;
    }
}

