/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.NetworkSend;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.network.Send;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AddOffsetsToTxnResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AlterReplicaLogDirsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ApiError;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.CreateAclsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.CreateDelegationTokenResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DeleteAclsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DeleteRecordsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DescribeAclsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DescribeDelegationTokenResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ExpireDelegationTokenResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.FetchResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.InitProducerIdResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.MetadataResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ProduceResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.RenewDelegationTokenResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ResponseHeader;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.SaslAuthenticateResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.SaslHandshakeResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.StopReplicaResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.SyncGroupResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.TxnOffsetCommitResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.WriteTxnMarkersResponse;

public abstract class AbstractResponse
extends AbstractRequestResponse {
    public static final int DEFAULT_THROTTLE_TIME = 0;

    protected Send toSend(String destination, ResponseHeader header, short apiVersion) {
        return new NetworkSend(destination, this.serialize(apiVersion, header));
    }

    public ByteBuffer serialize(short version, ResponseHeader responseHeader) {
        return AbstractResponse.serialize(responseHeader.toStruct(), this.toStruct(version));
    }

    public abstract Map<Errors, Integer> errorCounts();

    protected Map<Errors, Integer> errorCounts(Errors error) {
        return Collections.singletonMap(error, 1);
    }

    protected Map<Errors, Integer> errorCounts(Map<?, Errors> errors) {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (Errors error : errors.values()) {
            this.updateErrorCounts(errorCounts, error);
        }
        return errorCounts;
    }

    protected Map<Errors, Integer> apiErrorCounts(Map<?, ApiError> errors) {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (ApiError apiError : errors.values()) {
            this.updateErrorCounts(errorCounts, apiError.error());
        }
        return errorCounts;
    }

    protected void updateErrorCounts(Map<Errors, Integer> errorCounts, Errors error) {
        Integer count = errorCounts.get((Object)error);
        errorCounts.put(error, count == null ? 1 : count + 1);
    }

    protected abstract Struct toStruct(short var1);

    public static AbstractResponse parseResponse(ApiKeys apiKey, Struct struct) {
        switch (apiKey) {
            case PRODUCE: {
                return new ProduceResponse(struct);
            }
            case FETCH: {
                return FetchResponse.parse(struct);
            }
            case LIST_OFFSETS: {
                return new ListOffsetResponse(struct);
            }
            case METADATA: {
                return new MetadataResponse(struct);
            }
            case OFFSET_COMMIT: {
                return new OffsetCommitResponse(struct);
            }
            case OFFSET_FETCH: {
                return new OffsetFetchResponse(struct);
            }
            case FIND_COORDINATOR: {
                return new FindCoordinatorResponse(struct);
            }
            case JOIN_GROUP: {
                return new JoinGroupResponse(struct);
            }
            case HEARTBEAT: {
                return new HeartbeatResponse(struct);
            }
            case LEAVE_GROUP: {
                return new LeaveGroupResponse(struct);
            }
            case SYNC_GROUP: {
                return new SyncGroupResponse(struct);
            }
            case STOP_REPLICA: {
                return new StopReplicaResponse(struct);
            }
            case CONTROLLED_SHUTDOWN: {
                return new ControlledShutdownResponse(struct);
            }
            case UPDATE_METADATA: {
                return new UpdateMetadataResponse(struct);
            }
            case LEADER_AND_ISR: {
                return new LeaderAndIsrResponse(struct);
            }
            case DESCRIBE_GROUPS: {
                return new DescribeGroupsResponse(struct);
            }
            case LIST_GROUPS: {
                return new ListGroupsResponse(struct);
            }
            case SASL_HANDSHAKE: {
                return new SaslHandshakeResponse(struct);
            }
            case API_VERSIONS: {
                return new ApiVersionsResponse(struct);
            }
            case CREATE_TOPICS: {
                return new CreateTopicsResponse(struct);
            }
            case DELETE_TOPICS: {
                return new DeleteTopicsResponse(struct);
            }
            case DELETE_RECORDS: {
                return new DeleteRecordsResponse(struct);
            }
            case INIT_PRODUCER_ID: {
                return new InitProducerIdResponse(struct);
            }
            case OFFSET_FOR_LEADER_EPOCH: {
                return new OffsetsForLeaderEpochResponse(struct);
            }
            case ADD_PARTITIONS_TO_TXN: {
                return new AddPartitionsToTxnResponse(struct);
            }
            case ADD_OFFSETS_TO_TXN: {
                return new AddOffsetsToTxnResponse(struct);
            }
            case END_TXN: {
                return new EndTxnResponse(struct);
            }
            case WRITE_TXN_MARKERS: {
                return new WriteTxnMarkersResponse(struct);
            }
            case TXN_OFFSET_COMMIT: {
                return new TxnOffsetCommitResponse(struct);
            }
            case DESCRIBE_ACLS: {
                return new DescribeAclsResponse(struct);
            }
            case CREATE_ACLS: {
                return new CreateAclsResponse(struct);
            }
            case DELETE_ACLS: {
                return new DeleteAclsResponse(struct);
            }
            case DESCRIBE_CONFIGS: {
                return new DescribeConfigsResponse(struct);
            }
            case ALTER_CONFIGS: {
                return new AlterConfigsResponse(struct);
            }
            case ALTER_REPLICA_LOG_DIRS: {
                return new AlterReplicaLogDirsResponse(struct);
            }
            case DESCRIBE_LOG_DIRS: {
                return new DescribeLogDirsResponse(struct);
            }
            case SASL_AUTHENTICATE: {
                return new SaslAuthenticateResponse(struct);
            }
            case CREATE_PARTITIONS: {
                return new CreatePartitionsResponse(struct);
            }
            case CREATE_DELEGATION_TOKEN: {
                return new CreateDelegationTokenResponse(struct);
            }
            case RENEW_DELEGATION_TOKEN: {
                return new RenewDelegationTokenResponse(struct);
            }
            case EXPIRE_DELEGATION_TOKEN: {
                return new ExpireDelegationTokenResponse(struct);
            }
            case DESCRIBE_DELEGATION_TOKEN: {
                return new DescribeDelegationTokenResponse(struct);
            }
            case DELETE_GROUPS: {
                return new DeleteGroupsResponse(struct);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `parseResponse`, the code should be updated to do so.", new Object[]{apiKey}));
    }

    public boolean shouldClientThrottle(short version) {
        return false;
    }

    public int throttleTimeMs() {
        return 0;
    }

    public String toString(short version) {
        return this.toStruct(version).toString();
    }
}

