/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.internals;

public final class Heartbeat {
    private final int sessionTimeoutMs;
    private final int heartbeatIntervalMs;
    private final int maxPollIntervalMs;
    private final long retryBackoffMs;
    private volatile long lastHeartbeatSend;
    private long lastHeartbeatReceive;
    private long lastSessionReset;
    private long lastPoll;
    private boolean heartbeatFailed;

    public Heartbeat(int sessionTimeoutMs, int heartbeatIntervalMs, int maxPollIntervalMs, long retryBackoffMs) {
        if (heartbeatIntervalMs >= sessionTimeoutMs) {
            throw new IllegalArgumentException("Heartbeat must be set lower than the session timeout");
        }
        this.sessionTimeoutMs = sessionTimeoutMs;
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        this.maxPollIntervalMs = maxPollIntervalMs;
        this.retryBackoffMs = retryBackoffMs;
    }

    public void poll(long now) {
        this.lastPoll = now;
    }

    public void sentHeartbeat(long now) {
        this.lastHeartbeatSend = now;
        this.heartbeatFailed = false;
    }

    public void failHeartbeat() {
        this.heartbeatFailed = true;
    }

    public void receiveHeartbeat(long now) {
        this.lastHeartbeatReceive = now;
    }

    public boolean shouldHeartbeat(long now) {
        return this.timeToNextHeartbeat(now) == 0L;
    }

    public long lastHeartbeatSend() {
        return this.lastHeartbeatSend;
    }

    public long timeToNextHeartbeat(long now) {
        long delayToNextHeartbeat;
        long timeSinceLastHeartbeat = now - Math.max(this.lastHeartbeatSend, this.lastSessionReset);
        if (timeSinceLastHeartbeat > (delayToNextHeartbeat = this.heartbeatFailed ? this.retryBackoffMs : (long)this.heartbeatIntervalMs)) {
            return 0L;
        }
        return delayToNextHeartbeat - timeSinceLastHeartbeat;
    }

    public boolean sessionTimeoutExpired(long now) {
        return now - Math.max(this.lastSessionReset, this.lastHeartbeatReceive) > (long)this.sessionTimeoutMs;
    }

    public long interval() {
        return this.heartbeatIntervalMs;
    }

    public void resetTimeouts(long now) {
        this.lastSessionReset = now;
        this.lastPoll = now;
        this.heartbeatFailed = false;
    }

    public boolean pollTimeoutExpired(long now) {
        return now - this.lastPoll > (long)this.maxPollIntervalMs;
    }

    public long lastPollTime() {
        return this.lastPoll;
    }
}

