/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.connector.kafka.source.KafkaSource;
import org.apache.flink.connector.kafka.source.KafkaSourceBuilder;
import org.apache.flink.connector.kafka.source.enumerator.initializer.OffsetsInitializer;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaRecordDeserializationSchema;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.header.Header;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.table.DynamicKafkaDeserializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DataStreamScanProvider;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.connector.source.abilities.SupportsWatermarkPushDown;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class KafkaDynamicSource
implements ScanTableSource,
SupportsReadingMetadata,
SupportsWatermarkPushDown {
    protected DataType producedDataType;
    protected List<String> metadataKeys;
    @Nullable
    protected WatermarkStrategy<RowData> watermarkStrategy;
    private static final String VALUE_METADATA_PREFIX = "value.";
    protected final DataType physicalDataType;
    @Nullable
    protected final DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat;
    protected final DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat;
    protected final int[] keyProjection;
    protected final int[] valueProjection;
    @Nullable
    protected final String keyPrefix;
    protected final List<String> topics;
    protected final Pattern topicPattern;
    protected final Properties properties;
    protected final StartupMode startupMode;
    protected final Map<KafkaTopicPartition, Long> specificStartupOffsets;
    protected final long startupTimestampMillis;
    protected final boolean upsertMode;
    protected final String tableIdentifier;

    public KafkaDynamicSource(DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable List<String> topics, @Nullable Pattern topicPattern, Properties properties, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets, long startupTimestampMillis, boolean upsertMode, String tableIdentifier) {
        this.physicalDataType = (DataType)Preconditions.checkNotNull((Object)physicalDataType, (String)"Physical data type must not be null.");
        this.keyDecodingFormat = keyDecodingFormat;
        this.valueDecodingFormat = (DecodingFormat)Preconditions.checkNotNull(valueDecodingFormat, (String)"Value decoding format must not be null.");
        this.keyProjection = (int[])Preconditions.checkNotNull((Object)keyProjection, (String)"Key projection must not be null.");
        this.valueProjection = (int[])Preconditions.checkNotNull((Object)valueProjection, (String)"Value projection must not be null.");
        this.keyPrefix = keyPrefix;
        this.producedDataType = physicalDataType;
        this.metadataKeys = Collections.emptyList();
        this.watermarkStrategy = null;
        Preconditions.checkArgument((topics != null && topicPattern == null || topics == null && topicPattern != null ? 1 : 0) != 0, (Object)"Either Topic or Topic Pattern must be set for source.");
        this.topics = topics;
        this.topicPattern = topicPattern;
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
        this.startupMode = (StartupMode)((Object)Preconditions.checkNotNull((Object)((Object)startupMode), (String)"Startup mode must not be null."));
        this.specificStartupOffsets = (Map)Preconditions.checkNotNull(specificStartupOffsets, (String)"Specific offsets must not be null.");
        this.startupTimestampMillis = startupTimestampMillis;
        this.upsertMode = upsertMode;
        this.tableIdentifier = tableIdentifier;
    }

    public ChangelogMode getChangelogMode() {
        return this.valueDecodingFormat.getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
        DeserializationSchema<RowData> keyDeserialization = this.createDeserialization((DynamicTableSource.Context)context, this.keyDecodingFormat, this.keyProjection, this.keyPrefix);
        DeserializationSchema<RowData> valueDeserialization = this.createDeserialization((DynamicTableSource.Context)context, this.valueDecodingFormat, this.valueProjection, null);
        TypeInformation producedTypeInfo = context.createTypeInformation(this.producedDataType);
        final KafkaSource<RowData> kafkaSource = this.createKafkaSource(keyDeserialization, valueDeserialization, (TypeInformation<RowData>)producedTypeInfo);
        return new DataStreamScanProvider(){

            public DataStream<RowData> produceDataStream(StreamExecutionEnvironment execEnv) {
                if (KafkaDynamicSource.this.watermarkStrategy == null) {
                    KafkaDynamicSource.this.watermarkStrategy = WatermarkStrategy.noWatermarks();
                }
                return execEnv.fromSource((Source)kafkaSource, KafkaDynamicSource.this.watermarkStrategy, "KafkaSource-" + KafkaDynamicSource.this.tableIdentifier);
            }

            public boolean isBounded() {
                return kafkaSource.getBoundedness() == Boundedness.BOUNDED;
            }
        };
    }

    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        this.valueDecodingFormat.listReadableMetadata().forEach((key, value) -> metadataMap.put(VALUE_METADATA_PREFIX + key, (DataType)value));
        Stream.of(ReadableMetadata.values()).forEachOrdered(m -> metadataMap.putIfAbsent(m.key, m.dataType));
        return metadataMap;
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        List formatMetadataKeys = metadataKeys.stream().filter(k -> k.startsWith(VALUE_METADATA_PREFIX)).collect(Collectors.toList());
        ArrayList<String> connectorMetadataKeys = new ArrayList<String>(metadataKeys);
        connectorMetadataKeys.removeAll(formatMetadataKeys);
        Map formatMetadata = this.valueDecodingFormat.listReadableMetadata();
        if (formatMetadata.size() > 0) {
            List requestedFormatMetadataKeys = formatMetadataKeys.stream().map(k -> k.substring(VALUE_METADATA_PREFIX.length())).collect(Collectors.toList());
            this.valueDecodingFormat.applyReadableMetadata(requestedFormatMetadataKeys);
        }
        this.metadataKeys = connectorMetadataKeys;
        this.producedDataType = producedDataType;
    }

    public boolean supportsMetadataProjection() {
        return false;
    }

    public void applyWatermark(WatermarkStrategy<RowData> watermarkStrategy) {
        this.watermarkStrategy = watermarkStrategy;
    }

    public DynamicTableSource copy() {
        KafkaDynamicSource copy = new KafkaDynamicSource(this.physicalDataType, this.keyDecodingFormat, this.valueDecodingFormat, this.keyProjection, this.valueProjection, this.keyPrefix, this.topics, this.topicPattern, this.properties, this.startupMode, this.specificStartupOffsets, this.startupTimestampMillis, this.upsertMode, this.tableIdentifier);
        copy.producedDataType = this.producedDataType;
        copy.metadataKeys = this.metadataKeys;
        copy.watermarkStrategy = this.watermarkStrategy;
        return copy;
    }

    public String asSummaryString() {
        return "Kafka table source";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaDynamicSource that = (KafkaDynamicSource)o;
        return Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.physicalDataType, that.physicalDataType) && Objects.equals(this.keyDecodingFormat, that.keyDecodingFormat) && Objects.equals(this.valueDecodingFormat, that.valueDecodingFormat) && Arrays.equals(this.keyProjection, that.keyProjection) && Arrays.equals(this.valueProjection, that.valueProjection) && Objects.equals(this.keyPrefix, that.keyPrefix) && Objects.equals(this.topics, that.topics) && Objects.equals(String.valueOf(this.topicPattern), String.valueOf(that.topicPattern)) && Objects.equals(this.properties, that.properties) && this.startupMode == that.startupMode && Objects.equals(this.specificStartupOffsets, that.specificStartupOffsets) && this.startupTimestampMillis == that.startupTimestampMillis && Objects.equals(this.upsertMode, that.upsertMode) && Objects.equals(this.tableIdentifier, that.tableIdentifier) && Objects.equals(this.watermarkStrategy, that.watermarkStrategy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.producedDataType, this.metadataKeys, this.physicalDataType, this.keyDecodingFormat, this.valueDecodingFormat, this.keyProjection, this.valueProjection, this.keyPrefix, this.topics, this.topicPattern, this.properties, this.startupMode, this.specificStartupOffsets, this.startupTimestampMillis, this.upsertMode, this.tableIdentifier, this.watermarkStrategy});
    }

    protected KafkaSource<RowData> createKafkaSource(DeserializationSchema<RowData> keyDeserialization, DeserializationSchema<RowData> valueDeserialization, TypeInformation<RowData> producedTypeInfo) {
        KafkaDeserializationSchema<RowData> kafkaDeserializer = this.createKafkaDeserializationSchema(keyDeserialization, valueDeserialization, producedTypeInfo);
        KafkaSourceBuilder kafkaSourceBuilder = KafkaSource.builder();
        if (this.topics != null) {
            kafkaSourceBuilder.setTopics(this.topics);
        } else {
            kafkaSourceBuilder.setTopicPattern(this.topicPattern);
        }
        switch (this.startupMode) {
            case EARLIEST: {
                kafkaSourceBuilder.setStartingOffsets(OffsetsInitializer.earliest());
                break;
            }
            case LATEST: {
                kafkaSourceBuilder.setStartingOffsets(OffsetsInitializer.latest());
                break;
            }
            case GROUP_OFFSETS: {
                kafkaSourceBuilder.setStartingOffsets(OffsetsInitializer.committedOffsets());
                break;
            }
            case SPECIFIC_OFFSETS: {
                HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
                this.specificStartupOffsets.forEach((tp, offset) -> offsets.put(new TopicPartition(tp.getTopic(), tp.getPartition()), (Long)offset));
                kafkaSourceBuilder.setStartingOffsets(OffsetsInitializer.offsets(offsets));
                break;
            }
            case TIMESTAMP: {
                kafkaSourceBuilder.setStartingOffsets(OffsetsInitializer.timestamp(this.startupTimestampMillis));
            }
        }
        kafkaSourceBuilder.setProperties(this.properties).setDeserializer(KafkaRecordDeserializationSchema.of(kafkaDeserializer));
        return kafkaSourceBuilder.build();
    }

    private KafkaDeserializationSchema<RowData> createKafkaDeserializationSchema(DeserializationSchema<RowData> keyDeserialization, DeserializationSchema<RowData> valueDeserialization, TypeInformation<RowData> producedTypeInfo) {
        DynamicKafkaDeserializationSchema.MetadataConverter[] metadataConverters = (DynamicKafkaDeserializationSchema.MetadataConverter[])this.metadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).map(m -> m.converter).toArray(DynamicKafkaDeserializationSchema.MetadataConverter[]::new);
        boolean hasMetadata = this.metadataKeys.size() > 0;
        int adjustedPhysicalArity = this.producedDataType.getChildren().size() - this.metadataKeys.size();
        int[] adjustedValueProjection = IntStream.concat(IntStream.of(this.valueProjection), IntStream.range(this.keyProjection.length + this.valueProjection.length, adjustedPhysicalArity)).toArray();
        return new DynamicKafkaDeserializationSchema(adjustedPhysicalArity, keyDeserialization, this.keyProjection, valueDeserialization, adjustedValueProjection, hasMetadata, metadataConverters, producedTypeInfo, this.upsertMode);
    }

    @Nullable
    private DeserializationSchema<RowData> createDeserialization(DynamicTableSource.Context context, @Nullable DecodingFormat<DeserializationSchema<RowData>> format, int[] projection, @Nullable String prefix) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = DataTypeUtils.projectRow((DataType)this.physicalDataType, (int[])projection);
        if (prefix != null) {
            physicalFormatDataType = DataTypeUtils.stripRowPrefix((DataType)physicalFormatDataType, (String)prefix);
        }
        return (DeserializationSchema)format.createRuntimeDecoder(context, physicalFormatDataType);
    }

    static enum ReadableMetadata {
        TOPIC("topic", (DataType)DataTypes.STRING().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return StringData.fromString((String)record.topic());
            }
        }),
        PARTITION("partition", (DataType)DataTypes.INT().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return record.partition();
            }
        }),
        HEADERS("headers", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.BYTES().nullable())).notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                HashMap<StringData, byte[]> map = new HashMap<StringData, byte[]>();
                for (Header header : record.headers()) {
                    map.put(StringData.fromString((String)header.key()), header.value());
                }
                return new GenericMapData(map);
            }
        }),
        LEADER_EPOCH("leader-epoch", (DataType)DataTypes.INT().nullable(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return record.leaderEpoch().orElse(null);
            }
        }),
        OFFSET("offset", (DataType)DataTypes.BIGINT().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return record.offset();
            }
        }),
        TIMESTAMP("timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return TimestampData.fromEpochMillis((long)record.timestamp());
            }
        }),
        TIMESTAMP_TYPE("timestamp-type", (DataType)DataTypes.STRING().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return StringData.fromString((String)record.timestampType().toString());
            }
        });

        final String key;
        final DataType dataType;
        final DynamicKafkaDeserializationSchema.MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, DynamicKafkaDeserializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }
}

