/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.RequestHeaderData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ResponseHeader;

public class RequestHeader
implements AbstractRequestResponse {
    private final RequestHeaderData data;
    private final short headerVersion;

    public RequestHeader(Struct struct, short headerVersion) {
        this(new RequestHeaderData(struct, headerVersion), headerVersion);
    }

    public RequestHeader(ApiKeys requestApiKey, short requestVersion, String clientId, int correlationId) {
        this(new RequestHeaderData().setRequestApiKey(requestApiKey.id).setRequestApiVersion(requestVersion).setClientId(clientId).setCorrelationId(correlationId), ApiKeys.forId(requestApiKey.id).requestHeaderVersion(requestVersion));
    }

    public RequestHeader(RequestHeaderData data, short headerVersion) {
        this.data = data;
        this.headerVersion = headerVersion;
    }

    public Struct toStruct() {
        return this.data.toStruct(this.headerVersion);
    }

    public ApiKeys apiKey() {
        return ApiKeys.forId(this.data.requestApiKey());
    }

    public short apiVersion() {
        return this.data.requestApiVersion();
    }

    public short headerVersion() {
        return this.headerVersion;
    }

    public String clientId() {
        return this.data.clientId();
    }

    public int correlationId() {
        return this.data.correlationId();
    }

    public RequestHeaderData data() {
        return this.data;
    }

    public ResponseHeader toResponseHeader() {
        return new ResponseHeader(this.data.correlationId(), this.apiKey().responseHeaderVersion(this.apiVersion()));
    }

    public static RequestHeader parse(ByteBuffer buffer) {
        int apiKey = -1;
        try {
            apiKey = buffer.getShort();
            short apiVersion = buffer.getShort();
            short headerVersion = ApiKeys.forId(apiKey).requestHeaderVersion(apiVersion);
            buffer.rewind();
            return new RequestHeader(new RequestHeaderData(new ByteBufferAccessor(buffer), headerVersion), headerVersion);
        }
        catch (UnsupportedVersionException e) {
            throw new InvalidRequestException("Unknown API key " + apiKey, e);
        }
        catch (Throwable ex) {
            throw new InvalidRequestException("Error parsing request header. Our best guess of the apiKey is: " + apiKey, ex);
        }
    }

    public String toString() {
        return "RequestHeader(apiKey=" + (Object)((Object)this.apiKey()) + ", apiVersion=" + this.apiVersion() + ", clientId=" + this.clientId() + ", correlationId=" + this.correlationId() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestHeader that = (RequestHeader)o;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }
}

