/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class LeaveGroupResponse
extends AbstractResponse {
    public final LeaveGroupResponseData data;

    public LeaveGroupResponse(LeaveGroupResponseData data) {
        this.data = data;
    }

    public LeaveGroupResponse(List<LeaveGroupResponseData.MemberResponse> memberResponses, Errors topLevelError, int throttleTimeMs, short version) {
        if (version <= 2) {
            short errorCode = LeaveGroupResponse.getError(topLevelError, memberResponses).code();
            this.data = new LeaveGroupResponseData().setErrorCode(errorCode);
        } else {
            this.data = new LeaveGroupResponseData().setErrorCode(topLevelError.code()).setMembers(memberResponses);
        }
        if (version >= 1) {
            this.data.setThrottleTimeMs(throttleTimeMs);
        }
    }

    public LeaveGroupResponse(Struct struct) {
        short latestVersion = (short)(LeaveGroupResponseData.SCHEMAS.length - 1);
        this.data = new LeaveGroupResponseData(struct, latestVersion);
    }

    public LeaveGroupResponse(Struct struct, short version) {
        this.data = new LeaveGroupResponseData(struct, version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public List<LeaveGroupResponseData.MemberResponse> memberResponses() {
        return this.data.members();
    }

    public Errors error() {
        return LeaveGroupResponse.getError(Errors.forCode(this.data.errorCode()), this.data.members());
    }

    public Errors topLevelError() {
        return Errors.forCode(this.data.errorCode());
    }

    private static Errors getError(Errors topLevelError, List<LeaveGroupResponseData.MemberResponse> memberResponses) {
        if (topLevelError != Errors.NONE) {
            return topLevelError;
        }
        for (LeaveGroupResponseData.MemberResponse memberResponse : memberResponses) {
            Errors memberError = Errors.forCode(memberResponse.errorCode());
            if (memberError == Errors.NONE) continue;
            return memberError;
        }
        return Errors.NONE;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> combinedErrorCounts = new HashMap<Errors, Integer>();
        Errors topLevelError = Errors.forCode(this.data.errorCode());
        if (topLevelError != Errors.NONE) {
            this.updateErrorCounts(combinedErrorCounts, topLevelError);
        }
        for (LeaveGroupResponseData.MemberResponse memberResponse : this.data.members()) {
            Errors memberError = Errors.forCode(memberResponse.errorCode());
            if (memberError == Errors.NONE) continue;
            this.updateErrorCounts(combinedErrorCounts, memberError);
        }
        return combinedErrorCounts;
    }

    @Override
    public Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public static LeaveGroupResponse parse(ByteBuffer buffer, short versionId) {
        return new LeaveGroupResponse(ApiKeys.LEAVE_GROUP.parseResponse(versionId, buffer), versionId);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    public boolean equals(Object other) {
        return other instanceof LeaveGroupResponse && ((LeaveGroupResponse)other).data.equals(this.data);
    }

    public int hashCode() {
        return Objects.hashCode(this.data);
    }
}

