/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;

public class TxnOffsetCommitRequestData
implements ApiMessage {
    private String transactionalId;
    private String groupId;
    private long producerId;
    private short producerEpoch;
    private List<TxnOffsetCommitRequestTopic> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public TxnOffsetCommitRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public TxnOffsetCommitRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public TxnOffsetCommitRequestData() {
        this.transactionalId = "";
        this.groupId = "";
        this.producerId = 0L;
        this.producerEpoch = 0;
        this.topics = new ArrayList<TxnOffsetCommitRequestTopic>();
    }

    @Override
    public short apiKey() {
        return 28;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable _readable, short _version) {
        short length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field transactionalId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field transactionalId had invalid length " + length);
        }
        this.transactionalId = _readable.readString(length);
        length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field groupId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field groupId had invalid length " + length);
        }
        this.groupId = _readable.readString(length);
        this.producerId = _readable.readLong();
        this.producerEpoch = _readable.readShort();
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        ArrayList<TxnOffsetCommitRequestTopic> newCollection = new ArrayList<TxnOffsetCommitRequestTopic>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TxnOffsetCommitRequestTopic(_readable, _version));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        Object _stringBytes = _cache.getSerializedValue(this.transactionalId);
        _writable.writeShort((short)((byte[])_stringBytes).length);
        _writable.writeByteArray((byte[])_stringBytes);
        _stringBytes = _cache.getSerializedValue(this.groupId);
        _writable.writeShort((short)((byte[])_stringBytes).length);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeLong(this.producerId);
        _writable.writeShort(this.producerEpoch);
        _writable.writeInt(this.topics.size());
        _stringBytes = this.topics.iterator();
        while (_stringBytes.hasNext()) {
            TxnOffsetCommitRequestTopic topicsElement = (TxnOffsetCommitRequestTopic)_stringBytes.next();
            topicsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        this.transactionalId = struct.getString("transactional_id");
        this.groupId = struct.getString("group_id");
        this.producerId = struct.getLong("producer_id");
        this.producerEpoch = struct.getShort("producer_epoch");
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<TxnOffsetCommitRequestTopic>(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new TxnOffsetCommitRequestTopic((Struct)nestedObject, _version));
        }
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        struct.set("transactional_id", (Object)this.transactionalId);
        struct.set("group_id", (Object)this.groupId);
        struct.set("producer_id", (Object)this.producerId);
        struct.set("producer_epoch", (Object)this.producerEpoch);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (TxnOffsetCommitRequestTopic element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        byte[] _stringBytes = this.transactionalId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'transactionalId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.transactionalId, _stringBytes);
        _size += _stringBytes.length + 2;
        _stringBytes = this.groupId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'groupId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue(this.groupId, _stringBytes);
        _size += _stringBytes.length + 2;
        _size += 8;
        _size += 2;
        int _arraySize = 0;
        _arraySize += 4;
        for (TxnOffsetCommitRequestTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TxnOffsetCommitRequestData)) {
            return false;
        }
        TxnOffsetCommitRequestData other = (TxnOffsetCommitRequestData)obj;
        if (this.transactionalId == null ? other.transactionalId != null : !this.transactionalId.equals(other.transactionalId)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.producerId != other.producerId) {
            return false;
        }
        if (this.producerEpoch != other.producerEpoch) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.transactionalId == null ? 0 : this.transactionalId.hashCode());
        hashCode = 31 * hashCode + (this.groupId == null ? 0 : this.groupId.hashCode());
        hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
        hashCode = 31 * hashCode + this.producerEpoch;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "TxnOffsetCommitRequestData(transactionalId=" + (this.transactionalId == null ? "null" : "'" + this.transactionalId.toString() + "'") + ", groupId=" + (this.groupId == null ? "null" : "'" + this.groupId.toString() + "'") + ", producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public String groupId() {
        return this.groupId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public List<TxnOffsetCommitRequestTopic> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public TxnOffsetCommitRequestData setTransactionalId(String v) {
        this.transactionalId = v;
        return this;
    }

    public TxnOffsetCommitRequestData setGroupId(String v) {
        this.groupId = v;
        return this;
    }

    public TxnOffsetCommitRequestData setProducerId(long v) {
        this.producerId = v;
        return this;
    }

    public TxnOffsetCommitRequestData setProducerEpoch(short v) {
        this.producerEpoch = v;
        return this;
    }

    public TxnOffsetCommitRequestData setTopics(List<TxnOffsetCommitRequestTopic> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("transactional_id", Type.STRING, "The ID of the transaction."), new Field("group_id", Type.STRING, "The ID of the group."), new Field("producer_id", Type.INT64, "The current producer ID in use by the transactional ID."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer ID."), new Field("topics", new ArrayOf(TxnOffsetCommitRequestTopic.SCHEMA_0), "Each topic that we want to committ offsets for."));
        SCHEMA_2 = new Schema(new Field("transactional_id", Type.STRING, "The ID of the transaction."), new Field("group_id", Type.STRING, "The ID of the group."), new Field("producer_id", Type.INT64, "The current producer ID in use by the transactional ID."), new Field("producer_epoch", Type.INT16, "The current epoch associated with the producer ID."), new Field("topics", new ArrayOf(TxnOffsetCommitRequestTopic.SCHEMA_2), "Each topic that we want to committ offsets for."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class TxnOffsetCommitRequestPartition
    implements Message {
        private int partitionIndex;
        private long committedOffset;
        private int committedLeaderEpoch;
        private String committedMetadata;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public TxnOffsetCommitRequestPartition(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TxnOffsetCommitRequestPartition(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public TxnOffsetCommitRequestPartition() {
            this.partitionIndex = 0;
            this.committedOffset = 0L;
            this.committedLeaderEpoch = -1;
            this.committedMetadata = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TxnOffsetCommitRequestPartition");
            }
            this.partitionIndex = _readable.readInt();
            this.committedOffset = _readable.readLong();
            this.committedLeaderEpoch = _version >= 2 ? _readable.readInt() : -1;
            short length = _readable.readShort();
            if (length < 0) {
                this.committedMetadata = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field committedMetadata had invalid length " + length);
                }
                this.committedMetadata = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TxnOffsetCommitRequestPartition");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeLong(this.committedOffset);
            if (_version >= 2) {
                _writable.writeInt(this.committedLeaderEpoch);
            }
            if (this.committedMetadata == null) {
                _writable.writeShort((short)-1);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.committedMetadata);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TxnOffsetCommitRequestPartition");
            }
            this._unknownTaggedFields = null;
            this.partitionIndex = struct.getInt("partition_index");
            this.committedOffset = struct.getLong("committed_offset");
            this.committedLeaderEpoch = _version >= 2 ? struct.getInt("committed_leader_epoch") : -1;
            this.committedMetadata = struct.getString("committed_metadata");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TxnOffsetCommitRequestPartition");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("committed_offset", (Object)this.committedOffset);
            if (_version >= 2) {
                struct.set("committed_leader_epoch", (Object)this.committedLeaderEpoch);
            }
            struct.set("committed_metadata", (Object)this.committedMetadata);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TxnOffsetCommitRequestPartition");
            }
            _size += 4;
            _size += 8;
            if (_version >= 2) {
                _size += 4;
            }
            if (this.committedMetadata == null) {
                _size += 2;
            } else {
                byte[] _stringBytes = this.committedMetadata.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'committedMetadata' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.committedMetadata, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TxnOffsetCommitRequestPartition)) {
                return false;
            }
            TxnOffsetCommitRequestPartition other = (TxnOffsetCommitRequestPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.committedOffset != other.committedOffset) {
                return false;
            }
            if (this.committedLeaderEpoch != other.committedLeaderEpoch) {
                return false;
            }
            return !(this.committedMetadata == null ? other.committedMetadata != null : !this.committedMetadata.equals(other.committedMetadata));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.committedOffset >> 32) ^ (int)this.committedOffset);
            hashCode = 31 * hashCode + this.committedLeaderEpoch;
            hashCode = 31 * hashCode + (this.committedMetadata == null ? 0 : this.committedMetadata.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TxnOffsetCommitRequestPartition(partitionIndex=" + this.partitionIndex + ", committedOffset=" + this.committedOffset + ", committedLeaderEpoch=" + this.committedLeaderEpoch + ", committedMetadata=" + (this.committedMetadata == null ? "null" : "'" + this.committedMetadata.toString() + "'") + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long committedOffset() {
            return this.committedOffset;
        }

        public int committedLeaderEpoch() {
            return this.committedLeaderEpoch;
        }

        public String committedMetadata() {
            return this.committedMetadata;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TxnOffsetCommitRequestPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public TxnOffsetCommitRequestPartition setCommittedOffset(long v) {
            this.committedOffset = v;
            return this;
        }

        public TxnOffsetCommitRequestPartition setCommittedLeaderEpoch(int v) {
            this.committedLeaderEpoch = v;
            return this;
        }

        public TxnOffsetCommitRequestPartition setCommittedMetadata(String v) {
            this.committedMetadata = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The index of the partition within the topic."), new Field("committed_offset", Type.INT64, "The message offset to be committed."), new Field("committed_metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
            SCHEMA_2 = new Schema(new Field("partition_index", Type.INT32, "The index of the partition within the topic."), new Field("committed_offset", Type.INT64, "The message offset to be committed."), new Field("committed_leader_epoch", Type.INT32, "The leader epoch of the last consumed record."), new Field("committed_metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class TxnOffsetCommitRequestTopic
    implements Message {
        private String name;
        private List<TxnOffsetCommitRequestPartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;

        public TxnOffsetCommitRequestTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TxnOffsetCommitRequestTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public TxnOffsetCommitRequestTopic() {
            this.name = "";
            this.partitions = new ArrayList<TxnOffsetCommitRequestPartition>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 2;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TxnOffsetCommitRequestTopic");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            ArrayList<TxnOffsetCommitRequestPartition> newCollection = new ArrayList<TxnOffsetCommitRequestPartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new TxnOffsetCommitRequestPartition(_readable, _version));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TxnOffsetCommitRequestTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.partitions.size());
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                TxnOffsetCommitRequestPartition partitionsElement = (TxnOffsetCommitRequestPartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TxnOffsetCommitRequestTopic");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            Object[] _nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<TxnOffsetCommitRequestPartition>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.partitions.add(new TxnOffsetCommitRequestPartition((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of TxnOffsetCommitRequestTopic");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            Struct[] _nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (TxnOffsetCommitRequestPartition element : this.partitions) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("partitions", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TxnOffsetCommitRequestTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (TxnOffsetCommitRequestPartition partitionsElement : this.partitions) {
                _arraySize += partitionsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TxnOffsetCommitRequestTopic)) {
                return false;
            }
            TxnOffsetCommitRequestTopic other = (TxnOffsetCommitRequestTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "TxnOffsetCommitRequestTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<TxnOffsetCommitRequestPartition> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TxnOffsetCommitRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        public TxnOffsetCommitRequestTopic setPartitions(List<TxnOffsetCommitRequestPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(TxnOffsetCommitRequestPartition.SCHEMA_0), "The partitions inside the topic that we want to committ offsets for."));
            SCHEMA_2 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("partitions", new ArrayOf(TxnOffsetCommitRequestPartition.SCHEMA_2), "The partitions inside the topic that we want to committ offsets for."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

