/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.header.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.header.Header;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class RecordHeader
implements Header {
    private final String key;
    private ByteBuffer valueBuffer;
    private byte[] value;

    public RecordHeader(String key, byte[] value) {
        Objects.requireNonNull(key, "Null header keys are not permitted");
        this.key = key;
        this.value = value;
    }

    public RecordHeader(String key, ByteBuffer valueBuffer) {
        Objects.requireNonNull(key, "Null header keys are not permitted");
        this.key = key;
        this.valueBuffer = valueBuffer;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public byte[] value() {
        if (this.value == null && this.valueBuffer != null) {
            this.value = Utils.toArray(this.valueBuffer);
            this.valueBuffer = null;
        }
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordHeader header = (RecordHeader)o;
        return Objects.equals(this.key, header.key) && Arrays.equals(this.value(), header.value());
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.value());
        return result;
    }

    public String toString() {
        return "RecordHeader(key = " + this.key + ", value = " + Arrays.toString(this.value()) + ")";
    }
}

