/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.io.Closeable;
import java.util.function.Consumer;
import org.apache.flink.util.Preconditions;

class Recyclable<T>
implements Closeable {
    private T object;
    private final Consumer<T> recycler;

    public Recyclable(T object, Consumer<T> recycler) {
        this.object = Preconditions.checkNotNull(object);
        this.recycler = (Consumer)Preconditions.checkNotNull(recycler);
    }

    public T getObject() {
        Preconditions.checkState((!this.isRecycled() ? 1 : 0) != 0, (Object)"Already recycled");
        return this.object;
    }

    boolean isRecycled() {
        return this.object == null;
    }

    @Override
    public void close() {
        this.recycler.accept(this.object);
        this.object = null;
    }
}

