/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.EndTxnRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.EndTxnResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.EndTxnResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.TransactionResult;

public class EndTxnRequest
extends AbstractRequest {
    private final EndTxnRequestData data;

    private EndTxnRequest(EndTxnRequestData data, short version) {
        super(ApiKeys.END_TXN, version);
        this.data = data;
    }

    public TransactionResult result() {
        if (this.data.committed()) {
            return TransactionResult.COMMIT;
        }
        return TransactionResult.ABORT;
    }

    @Override
    public EndTxnRequestData data() {
        return this.data;
    }

    @Override
    public EndTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new EndTxnResponse(new EndTxnResponseData().setErrorCode(Errors.forException(e).code()).setThrottleTimeMs(throttleTimeMs));
    }

    public static EndTxnRequest parse(ByteBuffer buffer, short version) {
        return new EndTxnRequest(new EndTxnRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<EndTxnRequest> {
        public final EndTxnRequestData data;

        public Builder(EndTxnRequestData data) {
            super(ApiKeys.END_TXN);
            this.data = data;
        }

        @Override
        public EndTxnRequest build(short version) {
            return new EndTxnRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

