/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.util.Objects;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.ApiException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;

public class ApiError {
    public static final ApiError NONE = new ApiError(Errors.NONE, null);
    private final Errors error;
    private final String message;

    public static ApiError fromThrowable(Throwable t) {
        Throwable throwableToBeEncoded = Errors.maybeUnwrapException(t);
        Errors error = Errors.forException(throwableToBeEncoded);
        String message = error == Errors.UNKNOWN_SERVER_ERROR || error.message().equals(throwableToBeEncoded.getMessage()) ? null : throwableToBeEncoded.getMessage();
        return new ApiError(error, message);
    }

    public ApiError(Errors error) {
        this(error, error.message());
    }

    public ApiError(Errors error, String message) {
        this.error = error;
        this.message = message;
    }

    public ApiError(short code, String message) {
        this.error = Errors.forCode(code);
        this.message = message;
    }

    public boolean is(Errors error) {
        return this.error == error;
    }

    public boolean isFailure() {
        return !this.isSuccess();
    }

    public boolean isSuccess() {
        return this.is(Errors.NONE);
    }

    public Errors error() {
        return this.error;
    }

    public String message() {
        return this.message;
    }

    public String messageWithFallback() {
        if (this.message == null) {
            return this.error.message();
        }
        return this.message;
    }

    public ApiException exception() {
        return this.error.exception(this.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.error, this.message});
    }

    public boolean equals(Object o) {
        if (!(o instanceof ApiError)) {
            return false;
        }
        ApiError other = (ApiError)o;
        return Objects.equals((Object)this.error, (Object)other.error) && Objects.equals(this.message, other.message);
    }

    public String toString() {
        return "ApiError(error=" + (Object)((Object)this.error) + ", message=" + this.message + ")";
    }
}

