/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.stats;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.MetricConfig;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.internals.MetricsUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.metrics.stats.WindowedSum;

public class Rate
implements MeasurableStat {
    protected final TimeUnit unit;
    protected final SampledStat stat;

    public Rate() {
        this(TimeUnit.SECONDS);
    }

    public Rate(TimeUnit unit) {
        this(unit, new WindowedSum());
    }

    public Rate(SampledStat stat) {
        this(TimeUnit.SECONDS, stat);
    }

    public Rate(TimeUnit unit, SampledStat stat) {
        this.stat = stat;
        this.unit = unit;
    }

    public String unitName() {
        return this.unit.name().substring(0, this.unit.name().length() - 2).toLowerCase(Locale.ROOT);
    }

    @Override
    public void record(MetricConfig config, double value, long timeMs) {
        this.stat.record(config, value, timeMs);
    }

    @Override
    public double measure(MetricConfig config, long now) {
        double value = this.stat.measure(config, now);
        return value / MetricsUtils.convert(this.windowSize(config, now), this.unit);
    }

    public long windowSize(MetricConfig config, long now) {
        this.stat.purgeObsoleteSamples(config, now);
        long totalElapsedTimeMs = now - this.stat.oldest((long)now).lastWindowMs;
        int numFullWindows = (int)(totalElapsedTimeMs / config.timeWindowMs());
        int minFullWindows = config.samples() - 1;
        if (numFullWindows < minFullWindows) {
            totalElapsedTimeMs += (long)(minFullWindows - numFullWindows) * config.timeWindowMs();
        }
        return Math.max(totalElapsedTimeMs, 1L);
    }

    public String toString() {
        return "Rate(unit=" + (Object)((Object)this.unit) + ", stat=" + this.stat + ')';
    }
}

