/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;

public class LeaderChangeMessage
implements ApiMessage {
    short version;
    int leaderId;
    List<Voter> voters;
    List<Voter> grantingVoters;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("version", Type.INT16, "The version of the leader change message"), new Field("leader_id", Type.INT32, "The ID of the newly elected leader"), new Field("voters", new CompactArrayOf(Voter.SCHEMA_0), "The set of voters in the quorum for this epoch"), new Field("granting_voters", new CompactArrayOf(Voter.SCHEMA_0), "The voters who voted for the leader at the time of election"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public LeaderChangeMessage(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public LeaderChangeMessage() {
        this.version = 0;
        this.leaderId = 0;
        this.voters = new ArrayList<Voter>(0);
        this.grantingVoters = new ArrayList<Voter>(0);
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        this.version = _readable.readShort();
        this.leaderId = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field voters was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Voter> newCollection = new ArrayList<Voter>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new Voter(_readable, _version));
        }
        this.voters = newCollection;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field grantingVoters was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(new Voter(_readable, _version));
        }
        this.grantingVoters = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.version);
        _writable.writeInt(this.leaderId);
        _writable.writeUnsignedVarint(this.voters.size() + 1);
        for (Voter votersElement : this.voters) {
            votersElement.write(_writable, _cache, _version);
        }
        _writable.writeUnsignedVarint(this.grantingVoters.size() + 1);
        for (Voter grantingVotersElement : this.grantingVoters) {
            grantingVotersElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.voters.size() + 1));
        for (Voter votersElement : this.voters) {
            votersElement.addSize(_size, _cache, _version);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.grantingVoters.size() + 1));
        for (Voter grantingVotersElement : this.grantingVoters) {
            grantingVotersElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaderChangeMessage)) {
            return false;
        }
        LeaderChangeMessage other = (LeaderChangeMessage)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.leaderId != other.leaderId) {
            return false;
        }
        if (this.voters == null ? other.voters != null : !this.voters.equals(other.voters)) {
            return false;
        }
        if (this.grantingVoters == null ? other.grantingVoters != null : !this.grantingVoters.equals(other.grantingVoters)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.version;
        hashCode = 31 * hashCode + this.leaderId;
        hashCode = 31 * hashCode + (this.voters == null ? 0 : this.voters.hashCode());
        hashCode = 31 * hashCode + (this.grantingVoters == null ? 0 : this.grantingVoters.hashCode());
        return hashCode;
    }

    @Override
    public LeaderChangeMessage duplicate() {
        LeaderChangeMessage _duplicate = new LeaderChangeMessage();
        _duplicate.version = this.version;
        _duplicate.leaderId = this.leaderId;
        ArrayList<Voter> newVoters = new ArrayList<Voter>(this.voters.size());
        for (Voter _element : this.voters) {
            newVoters.add(_element.duplicate());
        }
        _duplicate.voters = newVoters;
        ArrayList<Voter> newGrantingVoters = new ArrayList<Voter>(this.grantingVoters.size());
        for (Voter _element : this.grantingVoters) {
            newGrantingVoters.add(_element.duplicate());
        }
        _duplicate.grantingVoters = newGrantingVoters;
        return _duplicate;
    }

    public String toString() {
        return "LeaderChangeMessage(version=" + this.version + ", leaderId=" + this.leaderId + ", voters=" + MessageUtil.deepToString(this.voters.iterator()) + ", grantingVoters=" + MessageUtil.deepToString(this.grantingVoters.iterator()) + ")";
    }

    public short version() {
        return this.version;
    }

    public int leaderId() {
        return this.leaderId;
    }

    public List<Voter> voters() {
        return this.voters;
    }

    public List<Voter> grantingVoters() {
        return this.grantingVoters;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LeaderChangeMessage setVersion(short v) {
        this.version = v;
        return this;
    }

    public LeaderChangeMessage setLeaderId(int v) {
        this.leaderId = v;
        return this;
    }

    public LeaderChangeMessage setVoters(List<Voter> v) {
        this.voters = v;
        return this;
    }

    public LeaderChangeMessage setGrantingVoters(List<Voter> v) {
        this.grantingVoters = v;
        return this;
    }

    public static class Voter
    implements Message {
        int voterId;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("voter_id", Type.INT32, ""), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Voter(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Voter() {
            this.voterId = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public void read(Readable _readable, short _version) {
            this.voterId = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.voterId);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Voter)) {
                return false;
            }
            Voter other = (Voter)obj;
            if (this.voterId != other.voterId) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.voterId;
            return hashCode;
        }

        @Override
        public Voter duplicate() {
            Voter _duplicate = new Voter();
            _duplicate.voterId = this.voterId;
            return _duplicate;
        }

        public String toString() {
            return "Voter(voterId=" + this.voterId + ")";
        }

        public int voterId() {
            return this.voterId;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Voter setVoterId(int v) {
            this.voterId = v;
            return this;
        }
    }
}

