/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Uuid;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class LeaderAndIsrResponseData
implements ApiMessage {
    short errorCode;
    List<LeaderAndIsrPartitionError> partitionErrors;
    LeaderAndIsrTopicErrorCollection topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 7;

    public LeaderAndIsrResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public LeaderAndIsrResponseData() {
        this.errorCode = 0;
        this.partitionErrors = new ArrayList<LeaderAndIsrPartitionError>(0);
        this.topics = new LeaderAndIsrTopicErrorCollection(0);
    }

    @Override
    public short apiKey() {
        return 4;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 7;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        AbstractCollection newCollection;
        int arrayLength;
        this.errorCode = _readable.readShort();
        if (_version <= 4) {
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionErrors was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    ((ArrayList)newCollection).add((LeaderAndIsrPartitionError)new LeaderAndIsrPartitionError(_readable, _version));
                }
                this.partitionErrors = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionErrors was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<LeaderAndIsrPartitionError>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    ((ArrayList)newCollection).add((LeaderAndIsrPartitionError)new LeaderAndIsrPartitionError(_readable, _version));
                }
                this.partitionErrors = newCollection;
            }
        } else {
            this.partitionErrors = new ArrayList<LeaderAndIsrPartitionError>(0);
        }
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new LeaderAndIsrTopicErrorCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                ((ImplicitLinkedHashCollection)newCollection).add((LeaderAndIsrTopicError)new LeaderAndIsrTopicError(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            this.topics = new LeaderAndIsrTopicErrorCollection(0);
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.errorCode);
        if (_version <= 4) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.partitionErrors.size() + 1);
                for (LeaderAndIsrPartitionError partitionErrorsElement : this.partitionErrors) {
                    partitionErrorsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.partitionErrors.size());
                for (LeaderAndIsrPartitionError partitionErrorsElement : this.partitionErrors) {
                    partitionErrorsElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.partitionErrors.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default partitionErrors at version " + _version);
        }
        if (_version >= 5) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (LeaderAndIsrTopicError topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else if (!this.topics.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default topics at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        if (_version <= 4) {
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionErrors.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (LeaderAndIsrPartitionError partitionErrorsElement : this.partitionErrors) {
                partitionErrorsElement.addSize(_size, _cache, _version);
            }
        }
        if (_version >= 5) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            for (LeaderAndIsrTopicError topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaderAndIsrResponseData)) {
            return false;
        }
        LeaderAndIsrResponseData other = (LeaderAndIsrResponseData)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.partitionErrors == null ? other.partitionErrors != null : !this.partitionErrors.equals(other.partitionErrors)) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.partitionErrors == null ? 0 : this.partitionErrors.hashCode());
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public LeaderAndIsrResponseData duplicate() {
        LeaderAndIsrResponseData _duplicate = new LeaderAndIsrResponseData();
        _duplicate.errorCode = this.errorCode;
        ArrayList<LeaderAndIsrPartitionError> newPartitionErrors = new ArrayList<LeaderAndIsrPartitionError>(this.partitionErrors.size());
        for (LeaderAndIsrPartitionError _element : this.partitionErrors) {
            newPartitionErrors.add(_element.duplicate());
        }
        _duplicate.partitionErrors = newPartitionErrors;
        LeaderAndIsrTopicErrorCollection newTopics = new LeaderAndIsrTopicErrorCollection(this.topics.size());
        for (LeaderAndIsrTopicError _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "LeaderAndIsrResponseData(errorCode=" + this.errorCode + ", partitionErrors=" + MessageUtil.deepToString(this.partitionErrors.iterator()) + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<LeaderAndIsrPartitionError> partitionErrors() {
        return this.partitionErrors;
    }

    public LeaderAndIsrTopicErrorCollection topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LeaderAndIsrResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public LeaderAndIsrResponseData setPartitionErrors(List<LeaderAndIsrPartitionError> v) {
        this.partitionErrors = v;
        return this;
    }

    public LeaderAndIsrResponseData setTopics(LeaderAndIsrTopicErrorCollection v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("partition_errors", new ArrayOf(LeaderAndIsrPartitionError.SCHEMA_0), "Each partition in v0 to v4 message."))));
        SCHEMA_4 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("partition_errors", new CompactArrayOf(LeaderAndIsrPartitionError.SCHEMA_4), "Each partition in v0 to v4 message."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("topics", new CompactArrayOf(LeaderAndIsrTopicError.SCHEMA_5), "Each topic"), Field.TaggedFieldsSection.of(new Object[0])));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
    }

    public static class LeaderAndIsrPartitionError
    implements Message {
        String topicName;
        int partitionIndex;
        short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public LeaderAndIsrPartitionError(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public LeaderAndIsrPartitionError() {
            this.topicName = "";
            this.partitionIndex = 0;
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version <= 4) {
                int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topicName was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topicName had invalid length " + length);
                }
                this.topicName = _readable.readString(length);
            } else {
                this.topicName = "";
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version <= 4) {
                byte[] _stringBytes = _cache.getSerializedValue(this.topicName);
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version <= 4) {
                byte[] _stringBytes = this.topicName.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topicName' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.topicName, _stringBytes);
                if (_version >= 4) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrPartitionError)) {
                return false;
            }
            LeaderAndIsrPartitionError other = (LeaderAndIsrPartitionError)obj;
            if (this.topicName == null ? other.topicName != null : !this.topicName.equals(other.topicName)) {
                return false;
            }
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topicName == null ? 0 : this.topicName.hashCode());
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        @Override
        public LeaderAndIsrPartitionError duplicate() {
            LeaderAndIsrPartitionError _duplicate = new LeaderAndIsrPartitionError();
            _duplicate.topicName = this.topicName;
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            return _duplicate;
        }

        public String toString() {
            return "LeaderAndIsrPartitionError(topicName=" + (this.topicName == null ? "null" : "'" + this.topicName.toString() + "'") + ", partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ")";
        }

        public String topicName() {
            return this.topicName;
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrPartitionError setTopicName(String v) {
            this.topicName = v;
            return this;
        }

        public LeaderAndIsrPartitionError setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public LeaderAndIsrPartitionError setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("topic_name", Type.STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."))));
            SCHEMA_4 = new Schema(new Field("topic_name", Type.COMPACT_STRING, "The topic name."), new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The partition error code, or 0 if there was no error."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }

    public static class LeaderAndIsrTopicErrorCollection
    extends ImplicitLinkedHashMultiCollection<LeaderAndIsrTopicError> {
        public LeaderAndIsrTopicErrorCollection() {
        }

        public LeaderAndIsrTopicErrorCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public LeaderAndIsrTopicErrorCollection(Iterator<LeaderAndIsrTopicError> iterator) {
            super(iterator);
        }

        @Override
        public LeaderAndIsrTopicError find(Uuid topicId) {
            LeaderAndIsrTopicError _key = new LeaderAndIsrTopicError();
            _key.setTopicId(topicId);
            return this.find(_key);
        }

        @Override
        public List<LeaderAndIsrTopicError> findAll(Uuid topicId) {
            LeaderAndIsrTopicError _key = new LeaderAndIsrTopicError();
            _key.setTopicId(topicId);
            return this.findAll(_key);
        }

        public LeaderAndIsrTopicErrorCollection duplicate() {
            LeaderAndIsrTopicErrorCollection _duplicate = new LeaderAndIsrTopicErrorCollection(this.size());
            for (LeaderAndIsrTopicError _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class LeaderAndIsrTopicError
    implements Message,
    ImplicitLinkedHashCollection.Element {
        Uuid topicId;
        List<LeaderAndIsrPartitionError> partitionErrors;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 5;
        public static final short HIGHEST_SUPPORTED_VERSION = 7;

        public LeaderAndIsrTopicError(Readable _readable, short _version) {
            this.read(_readable, _version);
            this.prev = -2;
            this.next = -2;
        }

        public LeaderAndIsrTopicError() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitionErrors = new ArrayList<LeaderAndIsrPartitionError>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 7;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderAndIsrTopicError");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitionErrors was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<LeaderAndIsrPartitionError> newCollection = new ArrayList<LeaderAndIsrPartitionError>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new LeaderAndIsrPartitionError(_readable, _version));
            }
            this.partitionErrors = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderAndIsrTopicError");
            }
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitionErrors.size() + 1);
            for (LeaderAndIsrPartitionError partitionErrorsElement : this.partitionErrors) {
                partitionErrorsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 7) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderAndIsrTopicError");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionErrors.size() + 1));
            for (LeaderAndIsrPartitionError partitionErrorsElement : this.partitionErrors) {
                partitionErrorsElement.addSize(_size, _cache, _version);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof LeaderAndIsrTopicError)) {
                return false;
            }
            LeaderAndIsrTopicError other = (LeaderAndIsrTopicError)obj;
            return this.topicId.equals(other.topicId);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderAndIsrTopicError)) {
                return false;
            }
            LeaderAndIsrTopicError other = (LeaderAndIsrTopicError)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitionErrors == null ? other.partitionErrors != null : !this.partitionErrors.equals(other.partitionErrors)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            return hashCode;
        }

        @Override
        public LeaderAndIsrTopicError duplicate() {
            LeaderAndIsrTopicError _duplicate = new LeaderAndIsrTopicError();
            _duplicate.topicId = this.topicId;
            ArrayList<LeaderAndIsrPartitionError> newPartitionErrors = new ArrayList<LeaderAndIsrPartitionError>(this.partitionErrors.size());
            for (LeaderAndIsrPartitionError _element : this.partitionErrors) {
                newPartitionErrors.add(_element.duplicate());
            }
            _duplicate.partitionErrors = newPartitionErrors;
            return _duplicate;
        }

        public String toString() {
            return "LeaderAndIsrTopicError(topicId=" + this.topicId.toString() + ", partitionErrors=" + MessageUtil.deepToString(this.partitionErrors.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<LeaderAndIsrPartitionError> partitionErrors() {
            return this.partitionErrors;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderAndIsrTopicError setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public LeaderAndIsrTopicError setPartitionErrors(List<LeaderAndIsrPartitionError> v) {
            this.partitionErrors = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("topic_id", Type.UUID, "The unique topic ID"), new Field("partition_errors", new CompactArrayOf(LeaderAndIsrPartitionError.SCHEMA_5), "Each partition."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{null, null, null, null, null, SCHEMA_5, SCHEMA_6, SCHEMA_7};
        }
    }
}

