/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.internals;

import java.util.Objects;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.FindCoordinatorRequest;

public class CoordinatorKey {
    public final String idValue;
    public final FindCoordinatorRequest.CoordinatorType type;

    private CoordinatorKey(FindCoordinatorRequest.CoordinatorType type, String idValue) {
        this.idValue = idValue;
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorKey that = (CoordinatorKey)o;
        return Objects.equals(this.idValue, that.idValue) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.idValue, this.type});
    }

    public String toString() {
        return "CoordinatorKey(idValue='" + this.idValue + '\'' + ", type=" + (Object)((Object)this.type) + ')';
    }

    public static CoordinatorKey byGroupId(String groupId) {
        return new CoordinatorKey(FindCoordinatorRequest.CoordinatorType.GROUP, groupId);
    }

    public static CoordinatorKey byTransactionalId(String transactionalId) {
        return new CoordinatorKey(FindCoordinatorRequest.CoordinatorType.TRANSACTION, transactionalId);
    }
}

