/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka;

import java.util.Map;
import java.util.function.Predicate;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Metric;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.metrics.Counter;

@Internal
public class MetricUtil {
    public static Metric getKafkaMetric(Map<MetricName, ? extends Metric> metrics, String metricGroup, String metricName) {
        return MetricUtil.getKafkaMetric(metrics, e -> ((MetricName)e.getKey()).group().equals(metricGroup) && ((MetricName)e.getKey()).name().equals(metricName));
    }

    public static Metric getKafkaMetric(Map<MetricName, ? extends Metric> metrics, Predicate<Map.Entry<MetricName, ? extends Metric>> filter) {
        return metrics.entrySet().stream().filter(filter).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalStateException("Cannot find Kafka metric matching current filter."));
    }

    public static void sync(Metric from, Counter to) {
        to.inc(((Number)from.metricValue()).longValue() - to.getCount());
    }
}

