/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class RemoveMembersFromConsumerGroupHandler
extends AdminApiHandler.Batched<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> {
    private final CoordinatorKey groupId;
    private final List<LeaveGroupRequestData.MemberIdentity> members;
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;

    public RemoveMembersFromConsumerGroupHandler(String groupId, List<LeaveGroupRequestData.MemberIdentity> members, LogContext logContext) {
        this.groupId = CoordinatorKey.byGroupId(groupId);
        this.members = members;
        this.log = logContext.logger(RemoveMembersFromConsumerGroupHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    @Override
    public String apiName() {
        return "leaveGroup";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> newFuture(String groupId) {
        return AdminApiFuture.forKeys(Collections.singleton(CoordinatorKey.byGroupId(groupId)));
    }

    private void validateKeys(Set<CoordinatorKey> groupIds) {
        if (!groupIds.equals(Collections.singleton(this.groupId))) {
            throw new IllegalArgumentException("Received unexpected group ids " + groupIds + " (expected only " + Collections.singleton(this.groupId) + ")");
        }
    }

    public LeaveGroupRequest.Builder buildBatchedRequest(int coordinatorId, Set<CoordinatorKey> groupIds) {
        this.validateKeys(groupIds);
        return new LeaveGroupRequest.Builder(this.groupId.idValue, this.members);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        this.validateKeys(groupIds);
        LeaveGroupResponse response = (LeaveGroupResponse)abstractResponse;
        Errors error = response.topLevelError();
        if (error != Errors.NONE) {
            HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
            HashSet<CoordinatorKey> groupsToUnmap = new HashSet<CoordinatorKey>();
            this.handleGroupError(this.groupId, error, failed, groupsToUnmap);
            return new AdminApiHandler.ApiResult<CoordinatorKey, Map<LeaveGroupRequestData.MemberIdentity, Errors>>(Collections.emptyMap(), failed, new ArrayList<CoordinatorKey>(groupsToUnmap));
        }
        HashMap<LeaveGroupRequestData.MemberIdentity, Errors> memberErrors = new HashMap<LeaveGroupRequestData.MemberIdentity, Errors>();
        for (LeaveGroupResponseData.MemberResponse memberResponse : response.memberResponses()) {
            memberErrors.put(new LeaveGroupRequestData.MemberIdentity().setMemberId(memberResponse.memberId()).setGroupInstanceId(memberResponse.groupInstanceId()), Errors.forCode(memberResponse.errorCode()));
        }
        return AdminApiHandler.ApiResult.completed(this.groupId, memberErrors);
    }

    private void handleGroupError(CoordinatorKey groupId, Errors error, Map<CoordinatorKey, Throwable> failed, Set<CoordinatorKey> groupsToUnmap) {
        switch (error) {
            case GROUP_AUTHORIZATION_FAILED: {
                this.log.debug("`LeaveGroup` request for group id {} failed due to error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("`LeaveGroup` request for group id {} failed because the coordinator is still in the process of loading state. Will retry", (Object)groupId.idValue);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("`LeaveGroup` request for group id {} returned error {}. Will attempt to find the coordinator again and retry", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            default: {
                this.log.error("`LeaveGroup` request for group id {} failed due to unexpected error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
            }
        }
    }
}

