/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin;

import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Uuid;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DeleteTopicsResult {
    private final Map<Uuid, KafkaFuture<Void>> topicIdFutures;
    private final Map<String, KafkaFuture<Void>> nameFutures;

    protected DeleteTopicsResult(Map<Uuid, KafkaFuture<Void>> topicIdFutures, Map<String, KafkaFuture<Void>> nameFutures) {
        if (topicIdFutures != null && nameFutures != null) {
            throw new IllegalArgumentException("topicIdFutures and nameFutures cannot both be specified.");
        }
        if (topicIdFutures == null && nameFutures == null) {
            throw new IllegalArgumentException("topicIdFutures and nameFutures cannot both be null.");
        }
        this.topicIdFutures = topicIdFutures;
        this.nameFutures = nameFutures;
    }

    static DeleteTopicsResult ofTopicIds(Map<Uuid, KafkaFuture<Void>> topicIdFutures) {
        return new DeleteTopicsResult(topicIdFutures, null);
    }

    static DeleteTopicsResult ofTopicNames(Map<String, KafkaFuture<Void>> nameFutures) {
        return new DeleteTopicsResult(null, nameFutures);
    }

    public Map<Uuid, KafkaFuture<Void>> topicIdValues() {
        return this.topicIdFutures;
    }

    public Map<String, KafkaFuture<Void>> topicNameValues() {
        return this.nameFutures;
    }

    @Deprecated
    public Map<String, KafkaFuture<Void>> values() {
        return this.nameFutures;
    }

    public KafkaFuture<Void> all() {
        return this.topicIdFutures == null ? KafkaFuture.allOf(this.nameFutures.values().toArray(new KafkaFuture[0])) : KafkaFuture.allOf(this.topicIdFutures.values().toArray(new KafkaFuture[0]));
    }
}

