/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.MemberDescription;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.ConsumerGroupState;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Node;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.acl.AclOperation;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Utils;

public class ConsumerGroupDescription {
    private final String groupId;
    private final boolean isSimpleConsumerGroup;
    private final Collection<MemberDescription> members;
    private final String partitionAssignor;
    private final ConsumerGroupState state;
    private final Node coordinator;
    private final Set<AclOperation> authorizedOperations;

    public ConsumerGroupDescription(String groupId, boolean isSimpleConsumerGroup, Collection<MemberDescription> members, String partitionAssignor, ConsumerGroupState state, Node coordinator) {
        this(groupId, isSimpleConsumerGroup, members, partitionAssignor, state, coordinator, Collections.emptySet());
    }

    public ConsumerGroupDescription(String groupId, boolean isSimpleConsumerGroup, Collection<MemberDescription> members, String partitionAssignor, ConsumerGroupState state, Node coordinator, Set<AclOperation> authorizedOperations) {
        this.groupId = groupId == null ? "" : groupId;
        this.isSimpleConsumerGroup = isSimpleConsumerGroup;
        this.members = members == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<MemberDescription>(members));
        this.partitionAssignor = partitionAssignor == null ? "" : partitionAssignor;
        this.state = state;
        this.coordinator = coordinator;
        this.authorizedOperations = authorizedOperations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerGroupDescription that = (ConsumerGroupDescription)o;
        return this.isSimpleConsumerGroup == that.isSimpleConsumerGroup && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.members, that.members) && Objects.equals(this.partitionAssignor, that.partitionAssignor) && this.state == that.state && Objects.equals(this.coordinator, that.coordinator) && Objects.equals(this.authorizedOperations, that.authorizedOperations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.groupId, this.isSimpleConsumerGroup, this.members, this.partitionAssignor, this.state, this.coordinator, this.authorizedOperations});
    }

    public String groupId() {
        return this.groupId;
    }

    public boolean isSimpleConsumerGroup() {
        return this.isSimpleConsumerGroup;
    }

    public Collection<MemberDescription> members() {
        return this.members;
    }

    public String partitionAssignor() {
        return this.partitionAssignor;
    }

    public ConsumerGroupState state() {
        return this.state;
    }

    public Node coordinator() {
        return this.coordinator;
    }

    public Set<AclOperation> authorizedOperations() {
        return this.authorizedOperations;
    }

    public String toString() {
        return "(groupId=" + this.groupId + ", isSimpleConsumerGroup=" + this.isSimpleConsumerGroup + ", members=" + Utils.join(this.members, ",") + ", partitionAssignor=" + this.partitionAssignor + ", state=" + (Object)((Object)this.state) + ", coordinator=" + this.coordinator + ", authorizedOperations=" + this.authorizedOperations + ")";
    }
}

