/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.sink;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.operators.MailboxExecutor;
import org.apache.flink.api.common.operators.ProcessingTimeService;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.api.connector.sink2.StatefulSink;
import org.apache.flink.api.connector.sink2.TwoPhaseCommittingSink;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.kafka.MetricUtil;
import org.apache.flink.connector.kafka.sink.DefaultKafkaSinkContext;
import org.apache.flink.connector.kafka.sink.FlinkKafkaInternalProducer;
import org.apache.flink.connector.kafka.sink.KafkaCommittable;
import org.apache.flink.connector.kafka.sink.KafkaRecordSerializationSchema;
import org.apache.flink.connector.kafka.sink.KafkaWriterState;
import org.apache.flink.connector.kafka.sink.TransactionAborter;
import org.apache.flink.connector.kafka.sink.TransactionalIdFactory;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.Callback;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Metric;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.MetricName;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.SinkWriterMetricGroup;
import org.apache.flink.streaming.connectors.kafka.internals.metrics.KafkaMetricMutableWrapper;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaWriter<IN>
implements StatefulSink.StatefulSinkWriter<IN, KafkaWriterState>,
TwoPhaseCommittingSink.PrecommittingSinkWriter<IN, KafkaCommittable> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaWriter.class);
    private static final String KAFKA_PRODUCER_METRIC_NAME = "KafkaProducer";
    private static final long METRIC_UPDATE_INTERVAL_MILLIS = 500L;
    private static final String KEY_DISABLE_METRICS = "flink.disable-metrics";
    private static final String KEY_REGISTER_METRICS = "register.producer.metrics";
    private static final String KAFKA_PRODUCER_METRICS = "producer-metrics";
    private final DeliveryGuarantee deliveryGuarantee;
    private final Properties kafkaProducerConfig;
    private final String transactionalIdPrefix;
    private final KafkaRecordSerializationSchema<IN> recordSerializer;
    private final Callback deliveryCallback;
    private final KafkaRecordSerializationSchema.KafkaSinkContext kafkaSinkContext;
    private volatile Exception asyncProducerException;
    private final Map<String, KafkaMetricMutableWrapper> previouslyCreatedMetrics = new HashMap<String, KafkaMetricMutableWrapper>();
    private final SinkWriterMetricGroup metricGroup;
    private final boolean disabledMetrics;
    private final Counter numRecordsOutCounter;
    private final Counter numBytesOutCounter;
    private final Counter numRecordsOutErrorsCounter;
    private final ProcessingTimeService timeService;
    private long latestOutgoingByteTotal;
    private Metric byteOutMetric;
    private FlinkKafkaInternalProducer<byte[], byte[]> currentProducer;
    private final KafkaWriterState kafkaWriterState;
    private final Deque<FlinkKafkaInternalProducer<byte[], byte[]>> producerPool = new ArrayDeque<FlinkKafkaInternalProducer<byte[], byte[]>>();
    private long lastCheckpointId;
    private final Deque<AutoCloseable> producerCloseables = new ArrayDeque<AutoCloseable>();
    private boolean closed = false;
    private long lastSync = System.currentTimeMillis();

    KafkaWriter(DeliveryGuarantee deliveryGuarantee, Properties kafkaProducerConfig, String transactionalIdPrefix, Sink.InitContext sinkInitContext, KafkaRecordSerializationSchema<IN> recordSerializer, SerializationSchema.InitializationContext schemaContext, Collection<KafkaWriterState> recoveredStates) {
        this.deliveryGuarantee = (DeliveryGuarantee)((Object)Preconditions.checkNotNull((Object)((Object)deliveryGuarantee), (String)"deliveryGuarantee"));
        this.kafkaProducerConfig = (Properties)Preconditions.checkNotNull((Object)kafkaProducerConfig, (String)"kafkaProducerConfig");
        this.transactionalIdPrefix = (String)Preconditions.checkNotNull((Object)transactionalIdPrefix, (String)"transactionalIdPrefix");
        this.recordSerializer = (KafkaRecordSerializationSchema)Preconditions.checkNotNull(recordSerializer, (String)"recordSerializer");
        Preconditions.checkNotNull((Object)sinkInitContext, (String)"sinkInitContext");
        this.deliveryCallback = new WriterCallback(sinkInitContext.getMailboxExecutor(), sinkInitContext.metadataConsumer().orElse(null));
        this.disabledMetrics = kafkaProducerConfig.containsKey(KEY_DISABLE_METRICS) && Boolean.parseBoolean(kafkaProducerConfig.get(KEY_DISABLE_METRICS).toString()) || kafkaProducerConfig.containsKey(KEY_REGISTER_METRICS) && !Boolean.parseBoolean(kafkaProducerConfig.get(KEY_REGISTER_METRICS).toString());
        this.timeService = sinkInitContext.getProcessingTimeService();
        this.metricGroup = sinkInitContext.metricGroup();
        this.numBytesOutCounter = this.metricGroup.getIOMetricGroup().getNumBytesOutCounter();
        this.numRecordsOutCounter = this.metricGroup.getIOMetricGroup().getNumRecordsOutCounter();
        this.numRecordsOutErrorsCounter = this.metricGroup.getNumRecordsOutErrorsCounter();
        this.kafkaSinkContext = new DefaultKafkaSinkContext(sinkInitContext.getSubtaskId(), sinkInitContext.getNumberOfParallelSubtasks(), kafkaProducerConfig);
        try {
            recordSerializer.open(schemaContext, this.kafkaSinkContext);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Cannot initialize schema.", (Throwable)e);
        }
        this.kafkaWriterState = new KafkaWriterState(transactionalIdPrefix);
        this.lastCheckpointId = sinkInitContext.getRestoredCheckpointId().orElse(0L);
        if (deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
            this.abortLingeringTransactions((Collection)Preconditions.checkNotNull(recoveredStates, (String)"recoveredStates"), this.lastCheckpointId + 1L);
            this.currentProducer = this.getTransactionalProducer(this.lastCheckpointId + 1L);
            this.currentProducer.beginTransaction();
        } else if (deliveryGuarantee == DeliveryGuarantee.AT_LEAST_ONCE || deliveryGuarantee == DeliveryGuarantee.NONE) {
            this.currentProducer = new FlinkKafkaInternalProducer(this.kafkaProducerConfig, null);
            this.producerCloseables.add(this.currentProducer);
            this.initKafkaMetrics(this.currentProducer);
        } else {
            throw new UnsupportedOperationException("Unsupported Kafka writer semantic " + (Object)((Object)this.deliveryGuarantee));
        }
        this.initFlinkMetrics();
    }

    public void write(@Nullable IN element, SinkWriter.Context context) throws IOException {
        this.checkAsyncException();
        ProducerRecord<byte[], byte[]> record = this.recordSerializer.serialize(element, this.kafkaSinkContext, context.timestamp());
        if (record != null) {
            this.currentProducer.send(record, this.deliveryCallback);
            this.numRecordsOutCounter.inc();
        }
    }

    public void flush(boolean endOfInput) throws IOException, InterruptedException {
        if (this.deliveryGuarantee != DeliveryGuarantee.NONE || endOfInput) {
            LOG.debug("final flush={}", (Object)endOfInput);
            this.currentProducer.flush();
        }
        this.checkAsyncException();
    }

    public Collection<KafkaCommittable> prepareCommit() {
        if (this.deliveryGuarantee != DeliveryGuarantee.EXACTLY_ONCE) {
            return Collections.emptyList();
        }
        if (this.currentProducer.hasRecordsInTransaction()) {
            List<KafkaCommittable> committables = Collections.singletonList(KafkaCommittable.of(this.currentProducer, this.producerPool::add));
            LOG.debug("Committing {} committables.", committables);
            return committables;
        }
        this.currentProducer.commitTransaction();
        this.producerPool.add(this.currentProducer);
        return Collections.emptyList();
    }

    public List<KafkaWriterState> snapshotState(long checkpointId) throws IOException {
        if (this.deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE) {
            this.currentProducer = this.getTransactionalProducer(checkpointId + 1L);
            this.currentProducer.beginTransaction();
        }
        return Collections.singletonList(this.kafkaWriterState);
    }

    public void close() throws Exception {
        this.closed = true;
        LOG.debug("Closing writer with {}", this.currentProducer);
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = this::abortCurrentProducer;
        autoCloseableArray[1] = this.producerPool::clear;
        IOUtils.closeAll((AutoCloseable[])autoCloseableArray);
        IOUtils.closeAll(this.producerCloseables);
        Preconditions.checkState((boolean)this.currentProducer.isClosed(), (Object)("Could not close current producer " + this.currentProducer));
        this.currentProducer = null;
        this.checkAsyncException();
    }

    private void abortCurrentProducer() {
        if (this.currentProducer.isInTransaction()) {
            try {
                this.currentProducer.abortTransaction();
            }
            catch (ProducerFencedException e) {
                LOG.debug("Producer {} fenced while aborting", (Object)this.currentProducer.getTransactionalId());
            }
        }
    }

    @VisibleForTesting
    Deque<FlinkKafkaInternalProducer<byte[], byte[]>> getProducerPool() {
        return this.producerPool;
    }

    @VisibleForTesting
    FlinkKafkaInternalProducer<byte[], byte[]> getCurrentProducer() {
        return this.currentProducer;
    }

    void abortLingeringTransactions(Collection<KafkaWriterState> recoveredStates, long startCheckpointId) {
        KafkaWriterState lastState;
        ArrayList<String> prefixesToAbort = new ArrayList<String>();
        prefixesToAbort.add(this.transactionalIdPrefix);
        Optional<KafkaWriterState> lastStateOpt = recoveredStates.stream().findFirst();
        if (lastStateOpt.isPresent() && !(lastState = lastStateOpt.get()).getTransactionalIdPrefix().equals(this.transactionalIdPrefix)) {
            prefixesToAbort.add(lastState.getTransactionalIdPrefix());
            LOG.warn("Transactional id prefix from previous execution {} has changed to {}.", (Object)lastState.getTransactionalIdPrefix(), (Object)this.transactionalIdPrefix);
        }
        try (TransactionAborter transactionAborter = new TransactionAborter(this.kafkaSinkContext.getParallelInstanceId(), this.kafkaSinkContext.getNumberOfParallelInstances(), this::getOrCreateTransactionalProducer, this.producerPool::add);){
            transactionAborter.abortLingeringTransactions(prefixesToAbort, startCheckpointId);
        }
    }

    private FlinkKafkaInternalProducer<byte[], byte[]> getTransactionalProducer(long checkpointId) {
        Preconditions.checkState((checkpointId > this.lastCheckpointId ? 1 : 0) != 0, (String)"Expected %s > %s", (Object[])new Object[]{checkpointId, this.lastCheckpointId});
        FlinkKafkaInternalProducer<byte[], byte[]> producer = null;
        for (long id = this.lastCheckpointId + 1L; id <= checkpointId; ++id) {
            String transactionalId = TransactionalIdFactory.buildTransactionalId(this.transactionalIdPrefix, this.kafkaSinkContext.getParallelInstanceId(), id);
            producer = this.getOrCreateTransactionalProducer(transactionalId);
        }
        this.lastCheckpointId = checkpointId;
        assert (producer != null);
        LOG.info("Created new transactional producer {}", (Object)producer.getTransactionalId());
        return producer;
    }

    private FlinkKafkaInternalProducer<byte[], byte[]> getOrCreateTransactionalProducer(String transactionalId) {
        FlinkKafkaInternalProducer<Object, Object> producer = this.producerPool.poll();
        if (producer == null) {
            producer = new FlinkKafkaInternalProducer(this.kafkaProducerConfig, transactionalId);
            this.producerCloseables.add(producer);
            producer.initTransactions();
            this.initKafkaMetrics(producer);
        } else {
            producer.initTransactionId(transactionalId);
        }
        return producer;
    }

    private void initFlinkMetrics() {
        this.metricGroup.setCurrentSendTimeGauge(this::computeSendTime);
        this.registerMetricSync();
    }

    private void initKafkaMetrics(FlinkKafkaInternalProducer<byte[], byte[]> producer) {
        this.byteOutMetric = MetricUtil.getKafkaMetric(producer.metrics(), KAFKA_PRODUCER_METRICS, "outgoing-byte-total");
        if (this.disabledMetrics) {
            return;
        }
        MetricGroup kafkaMetricGroup = this.metricGroup.addGroup(KAFKA_PRODUCER_METRIC_NAME);
        producer.metrics().entrySet().forEach(this.initMetric(kafkaMetricGroup));
    }

    private Consumer<Map.Entry<MetricName, ? extends Metric>> initMetric(MetricGroup kafkaMetricGroup) {
        return entry -> {
            String name = ((MetricName)entry.getKey()).name();
            Metric metric = (Metric)entry.getValue();
            if (this.previouslyCreatedMetrics.containsKey(name)) {
                KafkaMetricMutableWrapper wrapper = this.previouslyCreatedMetrics.get(name);
                wrapper.setKafkaMetric(metric);
            } else {
                KafkaMetricMutableWrapper wrapper = new KafkaMetricMutableWrapper(metric);
                this.previouslyCreatedMetrics.put(name, wrapper);
                kafkaMetricGroup.gauge(name, (Gauge)wrapper);
            }
        };
    }

    private long computeSendTime() {
        FlinkKafkaInternalProducer<byte[], byte[]> producer = this.currentProducer;
        if (producer == null) {
            return -1L;
        }
        Metric sendTime = MetricUtil.getKafkaMetric(producer.metrics(), KAFKA_PRODUCER_METRICS, "request-latency-avg");
        Metric queueTime = MetricUtil.getKafkaMetric(producer.metrics(), KAFKA_PRODUCER_METRICS, "record-queue-time-avg");
        return ((Number)sendTime.metricValue()).longValue() + ((Number)queueTime.metricValue()).longValue();
    }

    private void registerMetricSync() {
        this.timeService.registerTimer(this.lastSync + 500L, time -> {
            if (this.closed) {
                return;
            }
            long outgoingBytesUntilNow = ((Number)this.byteOutMetric.metricValue()).longValue();
            long outgoingBytesSinceLastUpdate = outgoingBytesUntilNow - this.latestOutgoingByteTotal;
            this.numBytesOutCounter.inc(outgoingBytesSinceLastUpdate);
            this.latestOutgoingByteTotal = outgoingBytesUntilNow;
            this.lastSync = time;
            this.registerMetricSync();
        });
    }

    private void checkAsyncException() throws IOException {
        Exception e = this.asyncProducerException;
        if (e != null) {
            this.asyncProducerException = null;
            this.numRecordsOutErrorsCounter.inc();
            throw new IOException("One or more Kafka Producer send requests have encountered exception", e);
        }
    }

    private class WriterCallback
    implements Callback {
        private final MailboxExecutor mailboxExecutor;
        @Nullable
        private final Consumer<RecordMetadata> metadataConsumer;

        public WriterCallback(@Nullable MailboxExecutor mailboxExecutor, Consumer<RecordMetadata> metadataConsumer) {
            this.mailboxExecutor = mailboxExecutor;
            this.metadataConsumer = metadataConsumer;
        }

        @Override
        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                FlinkKafkaInternalProducer producer = KafkaWriter.this.currentProducer;
                if (KafkaWriter.this.asyncProducerException == null) {
                    KafkaWriter.this.asyncProducerException = (Exception)this.decorateException(metadata, exception, producer);
                }
                this.mailboxExecutor.submit(() -> KafkaWriter.this.checkAsyncException(), "Update error metric");
            }
            if (this.metadataConsumer != null) {
                this.metadataConsumer.accept(metadata);
            }
        }

        private FlinkRuntimeException decorateException(RecordMetadata metadata, Exception exception, FlinkKafkaInternalProducer<byte[], byte[]> producer) {
            String message = String.format("Failed to send data to Kafka %s with %s ", metadata, producer);
            if (exception instanceof UnknownProducerIdException) {
                message = message + "because of a bug in the Kafka broker (KAFKA-9310). Please upgrade to Kafka 2.5+. If you are running with concurrent checkpoints, you also may want to try without them.\nTo avoid data loss, the application will restart.";
            }
            return new FlinkRuntimeException(message, (Throwable)exception);
        }
    }
}

