/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internals;

import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.kafka011.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.flink.streaming.connectors.kafka.KafkaContextAware;
import org.apache.flink.streaming.connectors.kafka.KafkaSerializationSchema;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;

@Internal
public class KafkaSerializationSchemaWrapper<T>
implements KafkaSerializationSchema<T>,
KafkaContextAware<T> {
    private final FlinkKafkaPartitioner<T> partitioner;
    private final SerializationSchema<T> serializationSchema;
    private final String topic;
    private boolean writeTimestamp;
    private int[] partitions;
    private int parallelInstanceId;
    private int numParallelInstances;

    public KafkaSerializationSchemaWrapper(String topic, FlinkKafkaPartitioner<T> partitioner, boolean writeTimestamp, SerializationSchema<T> serializationSchema) {
        this.partitioner = partitioner;
        this.serializationSchema = serializationSchema;
        this.topic = topic;
        this.writeTimestamp = writeTimestamp;
    }

    @Override
    public void open(SerializationSchema.InitializationContext context) throws Exception {
        this.serializationSchema.open(context);
        if (this.partitioner != null) {
            this.partitioner.open(this.parallelInstanceId, this.numParallelInstances);
        }
    }

    @Override
    public ProducerRecord<byte[], byte[]> serialize(T element, @Nullable Long timestamp) {
        byte[] serialized = this.serializationSchema.serialize(element);
        Integer partition = this.partitioner != null ? Integer.valueOf(this.partitioner.partition(element, null, serialized, this.topic, this.partitions)) : null;
        Long timestampToWrite = this.writeTimestamp ? timestamp : null;
        return new ProducerRecord<Object, byte[]>(this.topic, partition, timestampToWrite, null, serialized);
    }

    @Override
    public String getTargetTopic(T element) {
        return this.topic;
    }

    @Override
    public void setPartitions(int[] partitions) {
        this.partitions = partitions;
    }

    @Override
    public void setParallelInstanceId(int parallelInstanceId) {
        this.parallelInstanceId = parallelInstanceId;
    }

    @Override
    public void setNumParallelInstances(int numParallelInstances) {
        this.numParallelInstances = numParallelInstances;
    }

    public void setWriteTimestamp(boolean writeTimestamp) {
        this.writeTimestamp = writeTimestamp;
    }
}

