/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Protocol;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractRequestResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.ResponseHeader;

public class RequestHeader
extends AbstractRequestResponse {
    private static final Field API_KEY_FIELD = Protocol.REQUEST_HEADER.get("api_key");
    private static final Field API_VERSION_FIELD = Protocol.REQUEST_HEADER.get("api_version");
    private static final Field CLIENT_ID_FIELD = Protocol.REQUEST_HEADER.get("client_id");
    private static final Field CORRELATION_ID_FIELD = Protocol.REQUEST_HEADER.get("correlation_id");
    private final short apiKey;
    private final short apiVersion;
    private final String clientId;
    private final int correlationId;

    public RequestHeader(Struct struct) {
        this.apiKey = struct.getShort(API_KEY_FIELD);
        this.apiVersion = struct.getShort(API_VERSION_FIELD);
        this.clientId = struct.getString(CLIENT_ID_FIELD);
        this.correlationId = struct.getInt(CORRELATION_ID_FIELD);
    }

    public RequestHeader(short apiKey, short version, String client, int correlation) {
        this.apiKey = apiKey;
        this.apiVersion = version;
        this.clientId = client;
        this.correlationId = correlation;
    }

    public Struct toStruct() {
        Struct struct = new Struct(Protocol.REQUEST_HEADER);
        struct.set(API_KEY_FIELD, (Object)this.apiKey);
        struct.set(API_VERSION_FIELD, (Object)this.apiVersion);
        struct.set(CLIENT_ID_FIELD, (Object)this.clientId);
        struct.set(CORRELATION_ID_FIELD, (Object)this.correlationId);
        return struct;
    }

    public short apiKey() {
        return this.apiKey;
    }

    public short apiVersion() {
        return this.apiVersion;
    }

    public String clientId() {
        return this.clientId;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public ResponseHeader toResponseHeader() {
        return new ResponseHeader(this.correlationId);
    }

    public static RequestHeader parse(ByteBuffer buffer) {
        return new RequestHeader(Protocol.REQUEST_HEADER.read(buffer));
    }

    public String toString() {
        return this.toStruct().toString();
    }
}

