/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class OffsetsForLeaderEpochResponse
extends AbstractResponse {
    public static final String TOPICS = "topics";
    public static final String TOPIC = "topic";
    public static final String PARTITIONS = "partitions";
    public static final String ERROR_CODE = "error_code";
    public static final String PARTITION_ID = "partition_id";
    public static final String END_OFFSET = "end_offset";
    private Map<TopicPartition, EpochEndOffset> epochEndOffsetsByPartition;

    public OffsetsForLeaderEpochResponse(Struct struct) {
        this.epochEndOffsetsByPartition = new HashMap<TopicPartition, EpochEndOffset>();
        for (Object topicAndEpocsObj : struct.getArray(TOPICS)) {
            Struct topicAndEpochs = (Struct)topicAndEpocsObj;
            String topic = topicAndEpochs.getString(TOPIC);
            for (Object partitionAndEpochObj : topicAndEpochs.getArray(PARTITIONS)) {
                Struct partitionAndEpoch = (Struct)partitionAndEpochObj;
                Errors error = Errors.forCode(partitionAndEpoch.getShort(ERROR_CODE));
                int partitionId = partitionAndEpoch.getInt(PARTITION_ID);
                TopicPartition tp = new TopicPartition(topic, partitionId);
                long endOffset = partitionAndEpoch.getLong(END_OFFSET);
                this.epochEndOffsetsByPartition.put(tp, new EpochEndOffset(error, endOffset));
            }
        }
    }

    public OffsetsForLeaderEpochResponse(Map<TopicPartition, EpochEndOffset> epochsByTopic) {
        this.epochEndOffsetsByPartition = epochsByTopic;
    }

    public Map<TopicPartition, EpochEndOffset> responses() {
        return this.epochEndOffsetsByPartition;
    }

    public static OffsetsForLeaderEpochResponse parse(ByteBuffer buffer, short versionId) {
        return new OffsetsForLeaderEpochResponse(ApiKeys.OFFSET_FOR_LEADER_EPOCH.responseSchema(versionId).read(buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct responseStruct = new Struct(ApiKeys.OFFSET_FOR_LEADER_EPOCH.responseSchema(version));
        Map<String, Map<Integer, EpochEndOffset>> endOffsetsByTopic = CollectionUtils.groupDataByTopic(this.epochEndOffsetsByPartition);
        ArrayList<Struct> topics = new ArrayList<Struct>(endOffsetsByTopic.size());
        for (Map.Entry<String, Map<Integer, EpochEndOffset>> topicToPartitionEpochs : endOffsetsByTopic.entrySet()) {
            Struct topicStruct = responseStruct.instance(TOPICS);
            topicStruct.set(TOPIC, (Object)topicToPartitionEpochs.getKey());
            Map<Integer, EpochEndOffset> partitionEpochs = topicToPartitionEpochs.getValue();
            ArrayList<Struct> partitions = new ArrayList<Struct>();
            for (Map.Entry<Integer, EpochEndOffset> partitionEndOffset : partitionEpochs.entrySet()) {
                Struct partitionStruct = topicStruct.instance(PARTITIONS);
                partitionStruct.set(ERROR_CODE, (Object)partitionEndOffset.getValue().error().code());
                partitionStruct.set(PARTITION_ID, (Object)partitionEndOffset.getKey());
                partitionStruct.set(END_OFFSET, (Object)partitionEndOffset.getValue().endOffset());
                partitions.add(partitionStruct);
            }
            topicStruct.set(PARTITIONS, (Object)partitions.toArray());
            topics.add(topicStruct);
        }
        responseStruct.set(TOPICS, (Object)topics.toArray());
        return responseStruct;
    }
}

