/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class OffsetsForLeaderEpochRequest
extends AbstractRequest {
    public static final String TOPICS = "topics";
    public static final String TOPIC = "topic";
    public static final String PARTITIONS = "partitions";
    public static final String PARTITION_ID = "partition_id";
    public static final String LEADER_EPOCH = "leader_epoch";
    private Map<TopicPartition, Integer> epochsByPartition;

    public Map<TopicPartition, Integer> epochsByTopicPartition() {
        return this.epochsByPartition;
    }

    public OffsetsForLeaderEpochRequest(Map<TopicPartition, Integer> epochsByPartition, short version) {
        super(version);
        this.epochsByPartition = epochsByPartition;
    }

    public OffsetsForLeaderEpochRequest(Struct struct, short version) {
        super(version);
        this.epochsByPartition = new HashMap<TopicPartition, Integer>();
        for (Object topicAndEpochsObj : struct.getArray(TOPICS)) {
            Struct topicAndEpochs = (Struct)topicAndEpochsObj;
            String topic = topicAndEpochs.getString(TOPIC);
            for (Object partitionAndEpochObj : topicAndEpochs.getArray(PARTITIONS)) {
                Struct partitionAndEpoch = (Struct)partitionAndEpochObj;
                int partitionId = partitionAndEpoch.getInt(PARTITION_ID);
                int epoch = partitionAndEpoch.getInt(LEADER_EPOCH);
                TopicPartition tp = new TopicPartition(topic, partitionId);
                this.epochsByPartition.put(tp, epoch);
            }
        }
    }

    public static OffsetsForLeaderEpochRequest parse(ByteBuffer buffer, short versionId) {
        return new OffsetsForLeaderEpochRequest(ApiKeys.OFFSET_FOR_LEADER_EPOCH.parseRequest(versionId, buffer), versionId);
    }

    @Override
    protected Struct toStruct() {
        Struct requestStruct = new Struct(ApiKeys.OFFSET_FOR_LEADER_EPOCH.requestSchema(this.version()));
        Map<String, Map<Integer, Integer>> topicsToPartitionEpochs = CollectionUtils.groupDataByTopic(this.epochsByPartition);
        ArrayList<Struct> topics = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, Integer>> topicToEpochs : topicsToPartitionEpochs.entrySet()) {
            Struct topicsStruct = requestStruct.instance(TOPICS);
            topicsStruct.set(TOPIC, (Object)topicToEpochs.getKey());
            ArrayList<Struct> partitions = new ArrayList<Struct>();
            for (Map.Entry<Integer, Integer> partitionEpoch : topicToEpochs.getValue().entrySet()) {
                Struct partitionStruct = topicsStruct.instance(PARTITIONS);
                partitionStruct.set(PARTITION_ID, (Object)partitionEpoch.getKey());
                partitionStruct.set(LEADER_EPOCH, (Object)partitionEpoch.getValue());
                partitions.add(partitionStruct);
            }
            topicsStruct.set(PARTITIONS, (Object)partitions.toArray());
            topics.add(topicsStruct);
        }
        requestStruct.set(TOPICS, (Object)topics.toArray());
        return requestStruct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<TopicPartition, EpochEndOffset> errorResponse = new HashMap<TopicPartition, EpochEndOffset>();
        for (TopicPartition tp : this.epochsByPartition.keySet()) {
            errorResponse.put(tp, new EpochEndOffset(error, -1L));
        }
        return new OffsetsForLeaderEpochResponse(errorResponse);
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetsForLeaderEpochRequest> {
        private Map<TopicPartition, Integer> epochsByPartition = new HashMap<TopicPartition, Integer>();

        public Builder() {
            super(ApiKeys.OFFSET_FOR_LEADER_EPOCH);
        }

        public Builder(Map<TopicPartition, Integer> epochsByPartition) {
            super(ApiKeys.OFFSET_FOR_LEADER_EPOCH);
            this.epochsByPartition = epochsByPartition;
        }

        public Builder add(TopicPartition topicPartition, Integer epoch) {
            this.epochsByPartition.put(topicPartition, epoch);
            return this;
        }

        @Override
        public OffsetsForLeaderEpochRequest build(short version) {
            return new OffsetsForLeaderEpochRequest(this.epochsByPartition, version);
        }

        public static OffsetsForLeaderEpochRequest parse(ByteBuffer buffer, short version) {
            return new OffsetsForLeaderEpochRequest(ApiKeys.OFFSET_FOR_LEADER_EPOCH.parseRequest(version, buffer), version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=OffsetForLeaderEpochRequest, ").append("epochsByTopic=").append(this.epochsByPartition).append(")");
            return bld.toString();
        }
    }
}

