/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.utils.CollectionUtils;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.utils.Utils;

public class OffsetFetchRequest
extends AbstractRequest {
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITION_KEY_NAME = "partition";
    private final String groupId;
    private final List<TopicPartition> partitions;

    public static OffsetFetchRequest forAllPartitions(String groupId) {
        return new Builder(groupId, null).build((short)2);
    }

    private OffsetFetchRequest(String groupId, List<TopicPartition> partitions, short version) {
        super(version);
        this.groupId = groupId;
        this.partitions = partitions;
    }

    public OffsetFetchRequest(Struct struct, short version) {
        super(version);
        Object[] topicArray = struct.getArray(TOPICS_KEY_NAME);
        if (topicArray != null) {
            this.partitions = new ArrayList<TopicPartition>();
            for (Object topicResponseObj : struct.getArray(TOPICS_KEY_NAME)) {
                Struct topicResponse = (Struct)topicResponseObj;
                String topic = topicResponse.getString(TOPIC_KEY_NAME);
                for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                    Struct partitionResponse = (Struct)partitionResponseObj;
                    int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                    this.partitions.add(new TopicPartition(topic, partition));
                }
            }
        } else {
            this.partitions = null;
        }
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
    }

    public OffsetFetchResponse getErrorResponse(Errors error) {
        return this.getErrorResponse(0, error);
    }

    public OffsetFetchResponse getErrorResponse(int throttleTimeMs, Errors error) {
        short versionId = this.version();
        HashMap<TopicPartition, OffsetFetchResponse.PartitionData> responsePartitions = new HashMap<TopicPartition, OffsetFetchResponse.PartitionData>();
        if (versionId < 2) {
            for (TopicPartition partition : this.partitions) {
                responsePartitions.put(partition, new OffsetFetchResponse.PartitionData(-1L, "", error));
            }
        }
        switch (versionId) {
            case 0: 
            case 1: 
            case 2: {
                return new OffsetFetchResponse(error, responsePartitions);
            }
            case 3: {
                return new OffsetFetchResponse(throttleTimeMs, error, responsePartitions);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.OFFSET_FETCH.latestVersion()));
    }

    @Override
    public OffsetFetchResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return this.getErrorResponse(throttleTimeMs, Errors.forException(e));
    }

    public String groupId() {
        return this.groupId;
    }

    public List<TopicPartition> partitions() {
        return this.partitions;
    }

    public static OffsetFetchRequest parse(ByteBuffer buffer, short version) {
        return new OffsetFetchRequest(ApiKeys.OFFSET_FETCH.parseRequest(version, buffer), version);
    }

    public boolean isAllPartitions() {
        return this.partitions == null;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.OFFSET_FETCH.requestSchema(this.version()));
        struct.set(GROUP_ID_KEY_NAME, (Object)this.groupId);
        if (this.partitions != null) {
            Map<String, List<Integer>> topicsData = CollectionUtils.groupDataByTopic(this.partitions);
            ArrayList<Struct> topicArray = new ArrayList<Struct>();
            for (Map.Entry<String, List<Integer>> entries : topicsData.entrySet()) {
                Struct topicData = struct.instance(TOPICS_KEY_NAME);
                topicData.set(TOPIC_KEY_NAME, (Object)entries.getKey());
                ArrayList<Struct> partitionArray = new ArrayList<Struct>();
                for (Integer partitionId : entries.getValue()) {
                    Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                    partitionData.set(PARTITION_KEY_NAME, (Object)partitionId);
                    partitionArray.add(partitionData);
                }
                topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
                topicArray.add(topicData);
            }
            struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
        } else {
            struct.set(TOPICS_KEY_NAME, null);
        }
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<OffsetFetchRequest> {
        private static final List<TopicPartition> ALL_TOPIC_PARTITIONS = null;
        private final String groupId;
        private final List<TopicPartition> partitions;

        public Builder(String groupId, List<TopicPartition> partitions) {
            super(ApiKeys.OFFSET_FETCH);
            this.groupId = groupId;
            this.partitions = partitions;
        }

        public static Builder allTopicPartitions(String groupId) {
            return new Builder(groupId, ALL_TOPIC_PARTITIONS);
        }

        public boolean isAllTopicPartitions() {
            return this.partitions == ALL_TOPIC_PARTITIONS;
        }

        @Override
        public OffsetFetchRequest build(short version) {
            if (this.isAllTopicPartitions() && version < 2) {
                throw new UnsupportedVersionException("The broker only supports OffsetFetchRequest v" + version + ", but we need v2 or newer to request all topic partitions.");
            }
            return new OffsetFetchRequest(this.groupId, this.partitions, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            String partitionsString = this.partitions == null ? "<ALL>" : Utils.join(this.partitions, ",");
            bld.append("(type=OffsetFetchRequest, ").append("groupId=").append(this.groupId).append(", partitions=").append(partitionsString).append(")");
            return bld.toString();
        }
    }
}

