/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class DescribeGroupsResponse
extends AbstractResponse {
    private static final String GROUPS_KEY_NAME = "groups";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String GROUP_STATE_KEY_NAME = "state";
    private static final String PROTOCOL_TYPE_KEY_NAME = "protocol_type";
    private static final String PROTOCOL_KEY_NAME = "protocol";
    private static final String MEMBERS_KEY_NAME = "members";
    private static final String MEMBER_ID_KEY_NAME = "member_id";
    private static final String CLIENT_ID_KEY_NAME = "client_id";
    private static final String CLIENT_HOST_KEY_NAME = "client_host";
    private static final String MEMBER_METADATA_KEY_NAME = "member_metadata";
    private static final String MEMBER_ASSIGNMENT_KEY_NAME = "member_assignment";
    public static final String UNKNOWN_STATE = "";
    public static final String UNKNOWN_PROTOCOL_TYPE = "";
    public static final String UNKNOWN_PROTOCOL = "";
    private final Map<String, GroupMetadata> groups;
    private final int throttleTimeMs;

    public DescribeGroupsResponse(Map<String, GroupMetadata> groups) {
        this(0, groups);
    }

    public DescribeGroupsResponse(int throttleTimeMs, Map<String, GroupMetadata> groups) {
        this.throttleTimeMs = throttleTimeMs;
        this.groups = groups;
    }

    public DescribeGroupsResponse(Struct struct) {
        this.throttleTimeMs = struct.hasField("throttle_time_ms") ? struct.getInt("throttle_time_ms") : 0;
        this.groups = new HashMap<String, GroupMetadata>();
        for (Object groupObj : struct.getArray(GROUPS_KEY_NAME)) {
            Struct groupStruct = (Struct)groupObj;
            String groupId = groupStruct.getString(GROUP_ID_KEY_NAME);
            Errors error = Errors.forCode(groupStruct.getShort(ERROR_CODE_KEY_NAME));
            String state = groupStruct.getString(GROUP_STATE_KEY_NAME);
            String protocolType = groupStruct.getString(PROTOCOL_TYPE_KEY_NAME);
            String protocol = groupStruct.getString(PROTOCOL_KEY_NAME);
            ArrayList<GroupMember> members = new ArrayList<GroupMember>();
            for (Object memberObj : groupStruct.getArray(MEMBERS_KEY_NAME)) {
                Struct memberStruct = (Struct)memberObj;
                String memberId = memberStruct.getString(MEMBER_ID_KEY_NAME);
                String clientId = memberStruct.getString(CLIENT_ID_KEY_NAME);
                String clientHost = memberStruct.getString(CLIENT_HOST_KEY_NAME);
                ByteBuffer memberMetadata = memberStruct.getBytes(MEMBER_METADATA_KEY_NAME);
                ByteBuffer memberAssignment = memberStruct.getBytes(MEMBER_ASSIGNMENT_KEY_NAME);
                members.add(new GroupMember(memberId, clientId, clientHost, memberMetadata, memberAssignment));
            }
            this.groups.put(groupId, new GroupMetadata(error, state, protocolType, protocol, members));
        }
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<String, GroupMetadata> groups() {
        return this.groups;
    }

    public static DescribeGroupsResponse fromError(Errors error, List<String> groupIds) {
        return DescribeGroupsResponse.fromError(0, error, groupIds);
    }

    public static DescribeGroupsResponse fromError(int throttleTimeMs, Errors error, List<String> groupIds) {
        GroupMetadata errorMetadata = GroupMetadata.forError(error);
        HashMap<String, GroupMetadata> groups = new HashMap<String, GroupMetadata>();
        for (String groupId : groupIds) {
            groups.put(groupId, errorMetadata);
        }
        return new DescribeGroupsResponse(throttleTimeMs, groups);
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DESCRIBE_GROUPS.responseSchema(version));
        if (struct.hasField("throttle_time_ms")) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        ArrayList<Struct> groupStructs = new ArrayList<Struct>();
        for (Map.Entry<String, GroupMetadata> groupEntry : this.groups.entrySet()) {
            Struct groupStruct = struct.instance(GROUPS_KEY_NAME);
            GroupMetadata group = groupEntry.getValue();
            groupStruct.set(GROUP_ID_KEY_NAME, (Object)groupEntry.getKey());
            groupStruct.set(ERROR_CODE_KEY_NAME, (Object)group.error.code());
            groupStruct.set(GROUP_STATE_KEY_NAME, (Object)group.state);
            groupStruct.set(PROTOCOL_TYPE_KEY_NAME, (Object)group.protocolType);
            groupStruct.set(PROTOCOL_KEY_NAME, (Object)group.protocol);
            ArrayList<Struct> membersList = new ArrayList<Struct>();
            for (GroupMember member : group.members) {
                Struct memberStruct = groupStruct.instance(MEMBERS_KEY_NAME);
                memberStruct.set(MEMBER_ID_KEY_NAME, (Object)member.memberId);
                memberStruct.set(CLIENT_ID_KEY_NAME, (Object)member.clientId);
                memberStruct.set(CLIENT_HOST_KEY_NAME, (Object)member.clientHost);
                memberStruct.set(MEMBER_METADATA_KEY_NAME, (Object)member.memberMetadata);
                memberStruct.set(MEMBER_ASSIGNMENT_KEY_NAME, (Object)member.memberAssignment);
                membersList.add(memberStruct);
            }
            groupStruct.set(MEMBERS_KEY_NAME, (Object)membersList.toArray());
            groupStructs.add(groupStruct);
        }
        struct.set(GROUPS_KEY_NAME, (Object)groupStructs.toArray());
        return struct;
    }

    public static DescribeGroupsResponse parse(ByteBuffer buffer, short version) {
        return new DescribeGroupsResponse(ApiKeys.DESCRIBE_GROUPS.parseResponse(version, buffer));
    }

    public static class GroupMember {
        private final String memberId;
        private final String clientId;
        private final String clientHost;
        private final ByteBuffer memberMetadata;
        private final ByteBuffer memberAssignment;

        public GroupMember(String memberId, String clientId, String clientHost, ByteBuffer memberMetadata, ByteBuffer memberAssignment) {
            this.memberId = memberId;
            this.clientId = clientId;
            this.clientHost = clientHost;
            this.memberMetadata = memberMetadata;
            this.memberAssignment = memberAssignment;
        }

        public String memberId() {
            return this.memberId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String clientHost() {
            return this.clientHost;
        }

        public ByteBuffer memberMetadata() {
            return this.memberMetadata;
        }

        public ByteBuffer memberAssignment() {
            return this.memberAssignment;
        }
    }

    public static class GroupMetadata {
        private final Errors error;
        private final String state;
        private final String protocolType;
        private final String protocol;
        private final List<GroupMember> members;

        public GroupMetadata(Errors error, String state, String protocolType, String protocol, List<GroupMember> members) {
            this.error = error;
            this.state = state;
            this.protocolType = protocolType;
            this.protocol = protocol;
            this.members = members;
        }

        public Errors error() {
            return this.error;
        }

        public String state() {
            return this.state;
        }

        public String protocolType() {
            return this.protocolType;
        }

        public String protocol() {
            return this.protocol;
        }

        public List<GroupMember> members() {
            return this.members;
        }

        public static GroupMetadata forError(Errors error) {
            return new GroupMetadata(error, "", "", "", Collections.emptyList());
        }
    }
}

