/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.acl.AclBinding;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.ApiError;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.RequestUtils;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.resource.Resource;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAclsResponse
extends AbstractResponse {
    public static final Logger log = LoggerFactory.getLogger(DeleteAclsResponse.class);
    private static final String FILTER_RESPONSES = "filter_responses";
    private static final String MATCHING_ACLS = "matching_acls";
    private final int throttleTimeMs;
    private final List<AclFilterResponse> responses;

    public DeleteAclsResponse(int throttleTimeMs, List<AclFilterResponse> responses) {
        this.throttleTimeMs = throttleTimeMs;
        this.responses = responses;
    }

    public DeleteAclsResponse(Struct struct) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.responses = new ArrayList<AclFilterResponse>();
        for (Object responseStructObj : struct.getArray(FILTER_RESPONSES)) {
            Struct responseStruct = (Struct)responseStructObj;
            ApiError error = new ApiError(responseStruct);
            ArrayList<AclDeletionResult> deletions = new ArrayList<AclDeletionResult>();
            for (Object matchingAclStructObj : responseStruct.getArray(MATCHING_ACLS)) {
                Struct matchingAclStruct = (Struct)matchingAclStructObj;
                ApiError matchError = new ApiError(matchingAclStruct);
                AccessControlEntry entry = RequestUtils.aceFromStructFields(matchingAclStruct);
                Resource resource = RequestUtils.resourceFromStructFields(matchingAclStruct);
                deletions.add(new AclDeletionResult(matchError, new AclBinding(resource, entry)));
            }
            this.responses.add(new AclFilterResponse(error, deletions));
        }
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.DELETE_ACLS.responseSchema(version));
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        ArrayList<Struct> responseStructs = new ArrayList<Struct>();
        for (AclFilterResponse response : this.responses) {
            Struct responseStruct = struct.instance(FILTER_RESPONSES);
            response.error.write(responseStruct);
            ArrayList<Struct> deletionStructs = new ArrayList<Struct>();
            for (AclDeletionResult deletion : response.deletions()) {
                Struct deletionStruct = responseStruct.instance(MATCHING_ACLS);
                deletion.error.write(deletionStruct);
                RequestUtils.resourceSetStructFields(deletion.acl().resource(), deletionStruct);
                RequestUtils.aceSetStructFields(deletion.acl().entry(), deletionStruct);
                deletionStructs.add(deletionStruct);
            }
            responseStruct.set(MATCHING_ACLS, (Object)deletionStructs.toArray(new Struct[0]));
            responseStructs.add(responseStruct);
        }
        struct.set(FILTER_RESPONSES, (Object)responseStructs.toArray());
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public List<AclFilterResponse> responses() {
        return this.responses;
    }

    public static DeleteAclsResponse parse(ByteBuffer buffer, short version) {
        return new DeleteAclsResponse(ApiKeys.DELETE_ACLS.responseSchema(version).read(buffer));
    }

    public String toString() {
        return "(responses=" + Utils.join(this.responses, ",") + ")";
    }

    public static class AclFilterResponse {
        private final ApiError error;
        private final Collection<AclDeletionResult> deletions;

        public AclFilterResponse(ApiError error, Collection<AclDeletionResult> deletions) {
            this.error = error;
            this.deletions = deletions;
        }

        public AclFilterResponse(Collection<AclDeletionResult> deletions) {
            this(ApiError.NONE, deletions);
        }

        public ApiError error() {
            return this.error;
        }

        public Collection<AclDeletionResult> deletions() {
            return this.deletions;
        }

        public String toString() {
            return "(error=" + this.error + ", deletions=" + Utils.join(this.deletions, ",") + ")";
        }
    }

    public static class AclDeletionResult {
        private final ApiError error;
        private final AclBinding acl;

        public AclDeletionResult(ApiError error, AclBinding acl) {
            this.error = error;
            this.acl = acl;
        }

        public AclDeletionResult(AclBinding acl) {
            this(ApiError.NONE, acl);
        }

        public ApiError error() {
            return this.error;
        }

        public AclBinding acl() {
            return this.acl;
        }

        public String toString() {
            return "(error=" + this.error + ", acl=" + this.acl + ")";
        }
    }
}

