/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.ApiError;

public class CreateTopicsResponse
extends AbstractResponse {
    private static final String TOPIC_ERRORS_KEY_NAME = "topic_errors";
    private static final String TOPIC_KEY_NAME = "topic";
    private final Map<String, ApiError> errors;
    private final int throttleTimeMs;

    public CreateTopicsResponse(Map<String, ApiError> errors) {
        this(0, errors);
    }

    public CreateTopicsResponse(int throttleTimeMs, Map<String, ApiError> errors) {
        this.throttleTimeMs = throttleTimeMs;
        this.errors = errors;
    }

    public CreateTopicsResponse(Struct struct) {
        Object[] topicErrorStructs = struct.getArray(TOPIC_ERRORS_KEY_NAME);
        HashMap<String, ApiError> errors = new HashMap<String, ApiError>();
        for (Object topicErrorStructObj : topicErrorStructs) {
            Struct topicErrorStruct = (Struct)topicErrorStructObj;
            String topic = topicErrorStruct.getString(TOPIC_KEY_NAME);
            errors.put(topic, new ApiError(topicErrorStruct));
        }
        this.throttleTimeMs = struct.hasField("throttle_time_ms") ? struct.getInt("throttle_time_ms") : 0;
        this.errors = errors;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.CREATE_TOPICS.responseSchema(version));
        if (struct.hasField("throttle_time_ms")) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        ArrayList<Struct> topicErrorsStructs = new ArrayList<Struct>(this.errors.size());
        for (Map.Entry<String, ApiError> topicError : this.errors.entrySet()) {
            Struct topicErrorsStruct = struct.instance(TOPIC_ERRORS_KEY_NAME);
            topicErrorsStruct.set(TOPIC_KEY_NAME, (Object)topicError.getKey());
            topicError.getValue().write(topicErrorsStruct);
            topicErrorsStructs.add(topicErrorsStruct);
        }
        struct.set(TOPIC_ERRORS_KEY_NAME, (Object)topicErrorsStructs.toArray());
        return struct;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Map<String, ApiError> errors() {
        return this.errors;
    }

    public static CreateTopicsResponse parse(ByteBuffer buffer, short version) {
        return new CreateTopicsResponse(ApiKeys.CREATE_TOPICS.responseSchema(version).read(buffer));
    }
}

