/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.requests.AddPartitionsToTxnResponse;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.utils.CollectionUtils;

public class AddPartitionsToTxnRequest
extends AbstractRequest {
    private static final String TRANSACTIONAL_ID_KEY_NAME = "transactional_id";
    private static final String PRODUCER_ID_KEY_NAME = "producer_id";
    private static final String PRODUCER_EPOCH_KEY_NAME = "producer_epoch";
    private static final String TOPIC_PARTITIONS_KEY_NAME = "topics";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private final String transactionalId;
    private final long producerId;
    private final short producerEpoch;
    private final List<TopicPartition> partitions;

    private AddPartitionsToTxnRequest(short version, String transactionalId, long producerId, short producerEpoch, List<TopicPartition> partitions) {
        super(version);
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.partitions = partitions;
    }

    public AddPartitionsToTxnRequest(Struct struct, short version) {
        super(version);
        Object[] topicPartitionsArray;
        this.transactionalId = struct.getString(TRANSACTIONAL_ID_KEY_NAME);
        this.producerId = struct.getLong(PRODUCER_ID_KEY_NAME);
        this.producerEpoch = struct.getShort(PRODUCER_EPOCH_KEY_NAME);
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (Object topicPartitionObj : topicPartitionsArray = struct.getArray(TOPIC_PARTITIONS_KEY_NAME)) {
            Struct topicPartitionStruct = (Struct)topicPartitionObj;
            String topic = topicPartitionStruct.getString(TOPIC_KEY_NAME);
            for (Object partitionObj : topicPartitionStruct.getArray(PARTITIONS_KEY_NAME)) {
                partitions.add(new TopicPartition(topic, (Integer)partitionObj));
            }
        }
        this.partitions = partitions;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public List<TopicPartition> partitions() {
        return this.partitions;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.ADD_PARTITIONS_TO_TXN.requestSchema(this.version()));
        struct.set(TRANSACTIONAL_ID_KEY_NAME, (Object)this.transactionalId);
        struct.set(PRODUCER_ID_KEY_NAME, (Object)this.producerId);
        struct.set(PRODUCER_EPOCH_KEY_NAME, (Object)this.producerEpoch);
        Map<String, List<Integer>> mappedPartitions = CollectionUtils.groupDataByTopic(this.partitions);
        Object[] partitionsArray = new Object[mappedPartitions.size()];
        int i = 0;
        for (Map.Entry<String, List<Integer>> topicAndPartitions : mappedPartitions.entrySet()) {
            Struct topicPartitionsStruct = struct.instance(TOPIC_PARTITIONS_KEY_NAME);
            topicPartitionsStruct.set(TOPIC_KEY_NAME, (Object)topicAndPartitions.getKey());
            topicPartitionsStruct.set(PARTITIONS_KEY_NAME, (Object)topicAndPartitions.getValue().toArray());
            partitionsArray[i++] = topicPartitionsStruct;
        }
        struct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)partitionsArray);
        return struct;
    }

    @Override
    public AddPartitionsToTxnResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, Errors> errors = new HashMap<TopicPartition, Errors>();
        for (TopicPartition partition : this.partitions) {
            errors.put(partition, Errors.forException(e));
        }
        return new AddPartitionsToTxnResponse(throttleTimeMs, errors);
    }

    public static AddPartitionsToTxnRequest parse(ByteBuffer buffer, short version) {
        return new AddPartitionsToTxnRequest(ApiKeys.ADD_PARTITIONS_TO_TXN.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AddPartitionsToTxnRequest> {
        private final String transactionalId;
        private final long producerId;
        private final short producerEpoch;
        private final List<TopicPartition> partitions;

        public Builder(String transactionalId, long producerId, short producerEpoch, List<TopicPartition> partitions) {
            super(ApiKeys.ADD_PARTITIONS_TO_TXN);
            this.transactionalId = transactionalId;
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.partitions = partitions;
        }

        @Override
        public AddPartitionsToTxnRequest build(short version) {
            return new AddPartitionsToTxnRequest(version, this.transactionalId, this.producerId, this.producerEpoch, this.partitions);
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=AddPartitionsToTxnRequest").append(", transactionalId=").append(this.transactionalId).append(", producerId=").append(this.producerId).append(", producerEpoch=").append(this.producerEpoch).append(", partitions=").append(this.partitions).append(")");
            return bld.toString();
        }
    }
}

