/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol;

import java.nio.ByteBuffer;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.Protocol;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.types.Struct;

public enum ApiKeys {
    PRODUCE(0, "Produce"),
    FETCH(1, "Fetch"),
    LIST_OFFSETS(2, "Offsets"),
    METADATA(3, "Metadata"),
    LEADER_AND_ISR(4, "LeaderAndIsr", true),
    STOP_REPLICA(5, "StopReplica", true),
    UPDATE_METADATA_KEY(6, "UpdateMetadata", true),
    CONTROLLED_SHUTDOWN_KEY(7, "ControlledShutdown", true),
    OFFSET_COMMIT(8, "OffsetCommit"),
    OFFSET_FETCH(9, "OffsetFetch"),
    FIND_COORDINATOR(10, "FindCoordinator"),
    JOIN_GROUP(11, "JoinGroup"),
    HEARTBEAT(12, "Heartbeat"),
    LEAVE_GROUP(13, "LeaveGroup"),
    SYNC_GROUP(14, "SyncGroup"),
    DESCRIBE_GROUPS(15, "DescribeGroups"),
    LIST_GROUPS(16, "ListGroups"),
    SASL_HANDSHAKE(17, "SaslHandshake"),
    API_VERSIONS(18, "ApiVersions"){

        @Override
        public Struct parseResponse(short version, ByteBuffer buffer) {
            return this.parseResponse(version, buffer, (short)0);
        }
    }
    ,
    CREATE_TOPICS(19, "CreateTopics"),
    DELETE_TOPICS(20, "DeleteTopics"),
    DELETE_RECORDS(21, "DeleteRecords"),
    INIT_PRODUCER_ID(22, "InitProducerId"),
    OFFSET_FOR_LEADER_EPOCH(23, "OffsetForLeaderEpoch", true),
    ADD_PARTITIONS_TO_TXN(24, "AddPartitionsToTxn", false, 2),
    ADD_OFFSETS_TO_TXN(25, "AddOffsetsToTxn", false, 2),
    END_TXN(26, "EndTxn", false, 2),
    WRITE_TXN_MARKERS(27, "WriteTxnMarkers", true, 2),
    TXN_OFFSET_COMMIT(28, "TxnOffsetCommit", false, 2),
    DESCRIBE_ACLS(29, "DescribeAcls"),
    CREATE_ACLS(30, "CreateAcls"),
    DELETE_ACLS(31, "DeleteAcls"),
    DESCRIBE_CONFIGS(32, "DescribeConfigs"),
    ALTER_CONFIGS(33, "AlterConfigs");

    private static final ApiKeys[] ID_TO_TYPE;
    private static final int MIN_API_KEY = 0;
    public static final int MAX_API_KEY;
    public final short id;
    public final String name;
    public final boolean clusterAction;
    public final byte minRequiredInterBrokerMagic;

    private ApiKeys(int id, String name) {
        this(id, name, false);
    }

    private ApiKeys(int id, String name, boolean clusterAction) {
        this(id, name, clusterAction, 0);
    }

    private ApiKeys(int id, String name, boolean clusterAction, byte minRequiredInterBrokerMagic) {
        if (id < 0) {
            throw new IllegalArgumentException("id must not be negative, id: " + id);
        }
        this.id = (short)id;
        this.name = name;
        this.clusterAction = clusterAction;
        this.minRequiredInterBrokerMagic = minRequiredInterBrokerMagic;
    }

    public static ApiKeys forId(int id) {
        if (!ApiKeys.hasId(id)) {
            throw new IllegalArgumentException(String.format("Unexpected ApiKeys id `%s`, it should be between `%s` and `%s` (inclusive)", id, 0, MAX_API_KEY));
        }
        return ID_TO_TYPE[id];
    }

    public static boolean hasId(int id) {
        return id >= 0 && id <= MAX_API_KEY;
    }

    public short latestVersion() {
        if (this.id >= Protocol.CURR_VERSION.length) {
            throw new IllegalArgumentException("Latest version for API key " + (Object)((Object)this) + " is not defined");
        }
        return Protocol.CURR_VERSION[this.id];
    }

    public short oldestVersion() {
        if (this.id >= Protocol.MIN_VERSIONS.length) {
            throw new IllegalArgumentException("Oldest version for API key " + (Object)((Object)this) + " is not defined");
        }
        return Protocol.MIN_VERSIONS[this.id];
    }

    public Schema requestSchema(short version) {
        return this.schemaFor(Protocol.REQUESTS, version);
    }

    public Schema responseSchema(short version) {
        return this.schemaFor(Protocol.RESPONSES, version);
    }

    public Struct parseRequest(short version, ByteBuffer buffer) {
        return this.requestSchema(version).read(buffer);
    }

    public Struct parseResponse(short version, ByteBuffer buffer) {
        return this.responseSchema(version).read(buffer);
    }

    protected Struct parseResponse(short version, ByteBuffer buffer, short fallbackVersion) {
        int bufferPosition = buffer.position();
        try {
            return this.responseSchema(version).read(buffer);
        }
        catch (SchemaException e) {
            if (version != fallbackVersion) {
                buffer.position(bufferPosition);
                return this.responseSchema(fallbackVersion).read(buffer);
            }
            throw e;
        }
    }

    private Schema schemaFor(Schema[][] schemas, short version) {
        if (this.id > schemas.length) {
            throw new IllegalArgumentException("No schema available for API key " + (Object)((Object)this));
        }
        if (version < 0 || version > this.latestVersion()) {
            throw new IllegalArgumentException("Invalid version for API key " + (Object)((Object)this) + ": " + version);
        }
        Schema[] versions = schemas[this.id];
        if (versions[version] == null) {
            throw new IllegalArgumentException("Unsupported version for API key " + (Object)((Object)this) + ": " + version);
        }
        return versions[version];
    }

    private static String toHtml() {
        StringBuilder b = new StringBuilder();
        b.append("<table class=\"data-table\"><tbody>\n");
        b.append("<tr>");
        b.append("<th>Name</th>\n");
        b.append("<th>Key</th>\n");
        b.append("</tr>");
        for (ApiKeys key : ApiKeys.values()) {
            b.append("<tr>\n");
            b.append("<td>");
            b.append("<a href=\"#The_Messages_" + key.name + "\">" + key.name + "</a>");
            b.append("</td>");
            b.append("<td>");
            b.append(key.id);
            b.append("</td>");
            b.append("</tr>\n");
        }
        b.append("</table>\n");
        return b.toString();
    }

    public static void main(String[] args) {
        System.out.println(ApiKeys.toHtml());
    }

    static {
        int maxKey = -1;
        for (ApiKeys key : ApiKeys.values()) {
            maxKey = Math.max(maxKey, key.id);
        }
        ApiKeys[] idToType = new ApiKeys[maxKey + 1];
        ApiKeys[] arr$ = ApiKeys.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ApiKeys key;
            idToType[key.id] = key = arr$[i$];
        }
        ID_TO_TYPE = idToType;
        MAX_API_KEY = maxKey;
    }
}

