/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka011.shaded.org.apache.kafka.common.network;

import java.util.Map;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.config.AbstractConfig;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.network.ListenerName;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.network.Mode;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.security.JaasContext;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.security.auth.DefaultPrincipalBuilder;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.flink.kafka011.shaded.org.apache.kafka.common.utils.Utils;

public class ChannelBuilders {
    private ChannelBuilders() {
    }

    public static ChannelBuilder clientChannelBuilder(SecurityProtocol securityProtocol, JaasContext.Type contextType, AbstractConfig config, ListenerName listenerName, String clientSaslMechanism, boolean saslHandshakeRequestEnable) {
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            if (contextType == null) {
                throw new IllegalArgumentException("`contextType` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
            }
            if (clientSaslMechanism == null) {
                throw new IllegalArgumentException("`clientSaslMechanism` must be non-null in client mode if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
            }
        }
        return ChannelBuilders.create(securityProtocol, Mode.CLIENT, contextType, config, listenerName, clientSaslMechanism, saslHandshakeRequestEnable, null);
    }

    public static ChannelBuilder serverChannelBuilder(ListenerName listenerName, SecurityProtocol securityProtocol, AbstractConfig config, CredentialCache credentialCache) {
        return ChannelBuilders.create(securityProtocol, Mode.SERVER, JaasContext.Type.SERVER, config, listenerName, null, true, credentialCache);
    }

    private static ChannelBuilder create(SecurityProtocol securityProtocol, Mode mode, JaasContext.Type contextType, AbstractConfig config, ListenerName listenerName, String clientSaslMechanism, boolean saslHandshakeRequestEnable, CredentialCache credentialCache) {
        ChannelBuilder channelBuilder;
        Map<String, Object> configs = listenerName == null ? config.values() : config.valuesWithPrefixOverride(listenerName.configPrefix());
        switch (securityProtocol) {
            case SSL: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                channelBuilder = new SslChannelBuilder(mode);
                break;
            }
            case SASL_SSL: 
            case SASL_PLAINTEXT: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                JaasContext jaasContext = JaasContext.load(contextType, listenerName, configs);
                channelBuilder = new SaslChannelBuilder(mode, jaasContext, securityProtocol, clientSaslMechanism, saslHandshakeRequestEnable, credentialCache);
                break;
            }
            case PLAINTEXT: 
            case TRACE: {
                channelBuilder = new PlaintextChannelBuilder();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected securityProtocol " + (Object)((Object)securityProtocol));
            }
        }
        channelBuilder.configure(configs);
        return channelBuilder;
    }

    static PrincipalBuilder createPrincipalBuilder(Map<String, ?> configs) {
        Class principalBuilderClass = (Class)configs.get("principal.builder.class");
        PrincipalBuilder principalBuilder = principalBuilderClass == null ? new DefaultPrincipalBuilder() : (PrincipalBuilder)Utils.newInstance(principalBuilderClass);
        principalBuilder.configure(configs);
        return principalBuilder;
    }

    private static void requireNonNullMode(Mode mode, SecurityProtocol securityProtocol) {
        if (mode == null) {
            throw new IllegalArgumentException("`mode` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
        }
    }
}

