/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internal;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.io.ratelimiting.FlinkConnectorRateLimiter;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.streaming.connectors.kafka.internal.Handover;
import org.apache.flink.streaming.connectors.kafka.internal.KafkaConsumerThread;
import org.apache.flink.streaming.connectors.kafka.internals.AbstractFetcher;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaCommitCallback;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartitionState;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class Kafka010Fetcher<T>
extends AbstractFetcher<T, TopicPartition> {
    private static final Logger LOG = LoggerFactory.getLogger(Kafka010Fetcher.class);
    private final KafkaDeserializationSchema<T> deserializer;
    private final Handover handover;
    private final KafkaConsumerThread consumerThread;
    private volatile boolean running = true;
    private final KafkaCollector kafkaCollector = new KafkaCollector();

    public Kafka010Fetcher(SourceFunction.SourceContext<T> sourceContext, Map<KafkaTopicPartition, Long> assignedPartitionsWithInitialOffsets, SerializedValue<WatermarkStrategy<T>> watermarkStrategy, ProcessingTimeService processingTimeProvider, long autoWatermarkInterval, ClassLoader userCodeClassLoader, String taskNameWithSubtasks, KafkaDeserializationSchema<T> deserializer, Properties kafkaProperties, long pollTimeout, MetricGroup subtaskMetricGroup, MetricGroup consumerMetricGroup, boolean useMetrics, FlinkConnectorRateLimiter rateLimiter) throws Exception {
        super(sourceContext, assignedPartitionsWithInitialOffsets, watermarkStrategy, processingTimeProvider, autoWatermarkInterval, userCodeClassLoader, consumerMetricGroup, useMetrics);
        this.deserializer = deserializer;
        this.handover = new Handover();
        this.consumerThread = new KafkaConsumerThread(LOG, this.handover, kafkaProperties, this.unassignedPartitionsQueue, "Kafka 0.10 Fetcher for " + taskNameWithSubtasks, pollTimeout, useMetrics, consumerMetricGroup, subtaskMetricGroup, rateLimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runFetchLoop() throws Exception {
        try {
            Handover handover = this.handover;
            this.consumerThread.start();
            while (this.running) {
                ConsumerRecords<byte[], byte[]> records = handover.pollNext();
                block6: for (KafkaTopicPartitionState partition : this.subscribedPartitionStates()) {
                    List<ConsumerRecord<byte[], byte[]>> partitionRecords = records.records((TopicPartition)partition.getKafkaPartitionHandle());
                    for (ConsumerRecord<byte[], byte[]> record : partitionRecords) {
                        this.deserializer.deserialize(record, this.kafkaCollector);
                        this.emitRecordsWithTimestamps(this.kafkaCollector.getRecords(), partition, record.offset(), record.timestamp());
                        if (!this.kafkaCollector.isEndOfStreamSignalled()) continue;
                        this.running = false;
                        continue block6;
                    }
                }
            }
        }
        finally {
            this.consumerThread.shutdown();
        }
        try {
            this.consumerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void cancel() {
        this.running = false;
        this.handover.close();
        this.consumerThread.shutdown();
    }

    @Override
    public TopicPartition createKafkaPartitionHandle(KafkaTopicPartition partition) {
        return new TopicPartition(partition.getTopic(), partition.getPartition());
    }

    @Override
    protected void doCommitInternalOffsetsToKafka(Map<KafkaTopicPartition, Long> offsets, @Nonnull KafkaCommitCallback commitCallback) throws Exception {
        List partitions = this.subscribedPartitionStates();
        HashMap<TopicPartition, OffsetAndMetadata> offsetsToCommit = new HashMap<TopicPartition, OffsetAndMetadata>(partitions.size());
        for (KafkaTopicPartitionState partition : partitions) {
            Long lastProcessedOffset = offsets.get(partition.getKafkaTopicPartition());
            if (lastProcessedOffset == null) continue;
            Preconditions.checkState((lastProcessedOffset >= 0L ? 1 : 0) != 0, (Object)"Illegal offset value to commit");
            long offsetToCommit = lastProcessedOffset + 1L;
            offsetsToCommit.put((TopicPartition)partition.getKafkaPartitionHandle(), new OffsetAndMetadata(offsetToCommit));
            partition.setCommittedOffset(offsetToCommit);
        }
        this.consumerThread.setOffsetsToCommit(offsetsToCommit, commitCallback);
    }

    private class KafkaCollector
    implements Collector<T> {
        private final Queue<T> records = new ArrayDeque();
        private boolean endOfStreamSignalled = false;

        private KafkaCollector() {
        }

        public void collect(T record) {
            if (this.endOfStreamSignalled || Kafka010Fetcher.this.deserializer.isEndOfStream(record)) {
                this.endOfStreamSignalled = true;
                return;
            }
            this.records.add(record);
        }

        public Queue<T> getRecords() {
            return this.records;
        }

        public boolean isEndOfStreamSignalled() {
            return this.endOfStreamSignalled;
        }

        public void close() {
        }
    }
}

