/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.security.authenticator;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.RealmCallback;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.security.auth.Login;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogin
implements Login {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogin.class);
    private Configuration jaasConfig;
    private String loginContextName;
    private LoginContext loginContext;

    @Override
    public void configure(Map<String, ?> configs, Configuration jaasConfig, String loginContextName) {
        this.jaasConfig = jaasConfig;
        this.loginContextName = loginContextName;
    }

    @Override
    public LoginContext login() throws LoginException {
        this.loginContext = new LoginContext(this.loginContextName, null, new LoginCallbackHandler(), this.jaasConfig);
        this.loginContext.login();
        log.info("Successfully logged in.");
        return this.loginContext;
    }

    @Override
    public Subject subject() {
        return this.loginContext.getSubject();
    }

    protected Configuration jaasConfig() {
        return this.jaasConfig;
    }

    public static class LoginCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    String errorMessage = "Could not login: the client is being asked for a password, but the Kafka client code does not currently support obtaining a password from the user.";
                    throw new UnsupportedCallbackException(callback, errorMessage);
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL Login callback");
            }
        }
    }
}

