/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.TopicPartition;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.record.MemoryRecords;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.AbstractRequest;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.requests.FetchResponse;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.utils.Utils;

public class FetchRequest
extends AbstractRequest {
    public static final int CONSUMER_REPLICA_ID = -1;
    private static final String REPLICA_ID_KEY_NAME = "replica_id";
    private static final String MAX_WAIT_KEY_NAME = "max_wait_time";
    private static final String MIN_BYTES_KEY_NAME = "min_bytes";
    private static final String TOPICS_KEY_NAME = "topics";
    private static final String MAX_BYTES_KEY_NAME = "max_bytes";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String FETCH_OFFSET_KEY_NAME = "fetch_offset";
    public static final int DEFAULT_RESPONSE_MAX_BYTES = Integer.MAX_VALUE;
    private final int replicaId;
    private final int maxWait;
    private final int minBytes;
    private final int maxBytes;
    private final LinkedHashMap<TopicPartition, PartitionData> fetchData;

    private FetchRequest(short version, int replicaId, int maxWait, int minBytes, int maxBytes, LinkedHashMap<TopicPartition, PartitionData> fetchData) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.FETCH.id, version)), version);
        List<TopicAndPartitionData<PartitionData>> topicsData = TopicAndPartitionData.batchByTopic(fetchData);
        this.struct.set(REPLICA_ID_KEY_NAME, (Object)replicaId);
        this.struct.set(MAX_WAIT_KEY_NAME, (Object)maxWait);
        this.struct.set(MIN_BYTES_KEY_NAME, (Object)minBytes);
        if (version >= 3) {
            this.struct.set(MAX_BYTES_KEY_NAME, (Object)maxBytes);
        }
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (TopicAndPartitionData<PartitionData> topicEntry : topicsData) {
            Struct topicData = this.struct.instance(TOPICS_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.topic);
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry partitionEntry : topicEntry.partitions.entrySet()) {
                PartitionData fetchPartitionData = (PartitionData)partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(FETCH_OFFSET_KEY_NAME, (Object)fetchPartitionData.offset);
                partitionData.set(MAX_BYTES_KEY_NAME, (Object)fetchPartitionData.maxBytes);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(TOPICS_KEY_NAME, (Object)topicArray.toArray());
        this.replicaId = replicaId;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
        this.fetchData = fetchData;
    }

    public FetchRequest(Struct struct, short versionId) {
        super(struct, versionId);
        this.replicaId = struct.getInt(REPLICA_ID_KEY_NAME);
        this.maxWait = struct.getInt(MAX_WAIT_KEY_NAME);
        this.minBytes = struct.getInt(MIN_BYTES_KEY_NAME);
        this.maxBytes = struct.hasField(MAX_BYTES_KEY_NAME) ? struct.getInt(MAX_BYTES_KEY_NAME) : Integer.MAX_VALUE;
        this.fetchData = new LinkedHashMap();
        for (Object topicResponseObj : struct.getArray(TOPICS_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                long offset = partitionResponse.getLong(FETCH_OFFSET_KEY_NAME);
                int maxBytes = partitionResponse.getInt(MAX_BYTES_KEY_NAME);
                PartitionData partitionData = new PartitionData(offset, maxBytes);
                this.fetchData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> responseData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        for (Map.Entry<TopicPartition, PartitionData> entry : this.fetchData.entrySet()) {
            FetchResponse.PartitionData partitionResponse = new FetchResponse.PartitionData(Errors.forException(e).code(), -1L, MemoryRecords.EMPTY);
            responseData.put(entry.getKey(), partitionResponse);
        }
        short versionId = this.version();
        return new FetchResponse(versionId, responseData, 0);
    }

    public int replicaId() {
        return this.replicaId;
    }

    public int maxWait() {
        return this.maxWait;
    }

    public int minBytes() {
        return this.minBytes;
    }

    public int maxBytes() {
        return this.maxBytes;
    }

    public Map<TopicPartition, PartitionData> fetchData() {
        return this.fetchData;
    }

    public boolean isFromFollower() {
        return this.replicaId >= 0;
    }

    public static FetchRequest parse(ByteBuffer buffer, int versionId) {
        return new FetchRequest(ProtoUtils.parseRequest(ApiKeys.FETCH.id, versionId, buffer), (short)versionId);
    }

    public static FetchRequest parse(ByteBuffer buffer) {
        return FetchRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.FETCH.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<FetchRequest> {
        private int replicaId = -1;
        private int maxWait;
        private final int minBytes;
        private int maxBytes = Integer.MAX_VALUE;
        private LinkedHashMap<TopicPartition, PartitionData> fetchData;

        public Builder(int maxWait, int minBytes, LinkedHashMap<TopicPartition, PartitionData> fetchData) {
            super(ApiKeys.FETCH);
            this.maxWait = maxWait;
            this.minBytes = minBytes;
            this.fetchData = fetchData;
        }

        public Builder setReplicaId(int replicaId) {
            this.replicaId = replicaId;
            return this;
        }

        public Builder setMaxWait(int maxWait) {
            this.maxWait = maxWait;
            return this;
        }

        public Builder setMaxBytes(int maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        public LinkedHashMap<TopicPartition, PartitionData> fetchData() {
            return this.fetchData;
        }

        @Override
        public FetchRequest build() {
            short version = this.version();
            if (version < 3) {
                this.maxBytes = -1;
            }
            return new FetchRequest(version, this.replicaId, this.maxWait, this.minBytes, this.maxBytes, this.fetchData);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type:FetchRequest").append(", replicaId=").append(this.replicaId).append(", maxWait=").append(this.maxWait).append(", minBytes=").append(this.minBytes).append(", maxBytes=").append(this.maxBytes).append(", fetchData=").append(Utils.mkString(this.fetchData)).append(")");
            return bld.toString();
        }
    }

    static final class TopicAndPartitionData<T> {
        public final String topic;
        public final LinkedHashMap<Integer, T> partitions;

        public TopicAndPartitionData(String topic) {
            this.topic = topic;
            this.partitions = new LinkedHashMap();
        }

        public static <T> List<TopicAndPartitionData<T>> batchByTopic(LinkedHashMap<TopicPartition, T> data) {
            ArrayList<TopicAndPartitionData<T>> topics = new ArrayList<TopicAndPartitionData<T>>();
            for (Map.Entry<TopicPartition, T> topicEntry : data.entrySet()) {
                String topic = topicEntry.getKey().topic();
                int partition = topicEntry.getKey().partition();
                T partitionData = topicEntry.getValue();
                if (topics.isEmpty() || !((TopicAndPartitionData)topics.get((int)(topics.size() - 1))).topic.equals(topic)) {
                    topics.add(new TopicAndPartitionData<T>(topic));
                }
                ((TopicAndPartitionData)topics.get((int)(topics.size() - 1))).partitions.put(partition, partitionData);
            }
            return topics;
        }
    }

    public static final class PartitionData {
        public final long offset;
        public final int maxBytes;

        public PartitionData(long offset, int maxBytes) {
            this.offset = offset;
            this.maxBytes = maxBytes;
        }

        public String toString() {
            return "(offset=" + this.offset + ", maxBytes=" + this.maxBytes + ")";
        }
    }
}

