/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common.network;

import java.util.Map;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.ChannelBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.LoginType;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.Mode;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.PlaintextChannelBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.SaslChannelBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.security.auth.DefaultPrincipalBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.security.auth.PrincipalBuilder;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.utils.Utils;

public class ChannelBuilders {
    private ChannelBuilders() {
    }

    public static ChannelBuilder clientChannelBuilder(SecurityProtocol securityProtocol, LoginType loginType, Map<String, ?> configs, String clientSaslMechanism, boolean saslHandshakeRequestEnable) {
        if (securityProtocol == SecurityProtocol.SASL_PLAINTEXT || securityProtocol == SecurityProtocol.SASL_SSL) {
            if (loginType == null) {
                throw new IllegalArgumentException("`loginType` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
            }
            if (clientSaslMechanism == null) {
                throw new IllegalArgumentException("`clientSaslMechanism` must be non-null in client mode if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
            }
        }
        return ChannelBuilders.create(securityProtocol, Mode.CLIENT, loginType, configs, clientSaslMechanism, saslHandshakeRequestEnable, null);
    }

    public static ChannelBuilder serverChannelBuilder(SecurityProtocol securityProtocol, Map<String, ?> configs, CredentialCache credentialCache) {
        return ChannelBuilders.create(securityProtocol, Mode.SERVER, LoginType.SERVER, configs, null, true, credentialCache);
    }

    private static ChannelBuilder create(SecurityProtocol securityProtocol, Mode mode, LoginType loginType, Map<String, ?> configs, String clientSaslMechanism, boolean saslHandshakeRequestEnable, CredentialCache credentialCache) {
        ChannelBuilder channelBuilder;
        switch (securityProtocol) {
            case SSL: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                channelBuilder = new SslChannelBuilder(mode);
                break;
            }
            case SASL_SSL: 
            case SASL_PLAINTEXT: {
                ChannelBuilders.requireNonNullMode(mode, securityProtocol);
                channelBuilder = new SaslChannelBuilder(mode, loginType, securityProtocol, clientSaslMechanism, saslHandshakeRequestEnable, credentialCache);
                break;
            }
            case PLAINTEXT: 
            case TRACE: {
                channelBuilder = new PlaintextChannelBuilder();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected securityProtocol " + (Object)((Object)securityProtocol));
            }
        }
        channelBuilder.configure(configs);
        return channelBuilder;
    }

    static PrincipalBuilder createPrincipalBuilder(Map<String, ?> configs) {
        Class principalBuilderClass = (Class)configs.get("principal.builder.class");
        PrincipalBuilder principalBuilder = principalBuilderClass == null ? new DefaultPrincipalBuilder() : (PrincipalBuilder)Utils.newInstance(principalBuilderClass);
        principalBuilder.configure(configs);
        return principalBuilder;
    }

    private static void requireNonNullMode(Mode mode, SecurityProtocol securityProtocol) {
        if (mode == null) {
            throw new IllegalArgumentException("`mode` must be non-null if `securityProtocol` is `" + (Object)((Object)securityProtocol) + "`");
        }
    }
}

