/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.common;

import org.apache.flink.kafka010.shaded.org.apache.kafka.common.Node;

public class PartitionInfo {
    private final String topic;
    private final int partition;
    private final Node leader;
    private final Node[] replicas;
    private final Node[] inSyncReplicas;

    public PartitionInfo(String topic, int partition, Node leader, Node[] replicas, Node[] inSyncReplicas) {
        this.topic = topic;
        this.partition = partition;
        this.leader = leader;
        this.replicas = replicas;
        this.inSyncReplicas = inSyncReplicas;
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public Node leader() {
        return this.leader;
    }

    public Node[] replicas() {
        return this.replicas;
    }

    public Node[] inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public String toString() {
        return String.format("Partition(topic = %s, partition = %d, leader = %s, replicas = %s, isr = %s)", this.topic, this.partition, this.leader == null ? "none" : this.leader.idString(), this.formatNodeIds(this.replicas), this.formatNodeIds(this.inSyncReplicas));
    }

    private String formatNodeIds(Node[] nodes) {
        StringBuilder b = new StringBuilder("[");
        for (int i = 0; i < nodes.length; ++i) {
            b.append(nodes[i].idString());
            if (i >= nodes.length - 1) continue;
            b.append(',');
        }
        b.append("]");
        return b.toString();
    }
}

