/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka010.shaded.org.apache.kafka.clients.consumer.internals;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.consumer.internals.NoAvailableBrokersException;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.consumer.internals.RequestFutureAdapter;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.consumer.internals.RequestFutureListener;
import org.apache.flink.kafka010.shaded.org.apache.kafka.clients.consumer.internals.StaleMetadataException;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.errors.RetriableException;
import org.apache.flink.kafka010.shaded.org.apache.kafka.common.protocol.Errors;

public class RequestFuture<T>
implements ConsumerNetworkClient.PollCondition {
    private static final Object INCOMPLETE_SENTINEL = new Object();
    private final AtomicReference<Object> result = new AtomicReference<Object>(INCOMPLETE_SENTINEL);
    private final ConcurrentLinkedQueue<RequestFutureListener<T>> listeners = new ConcurrentLinkedQueue();

    public boolean isDone() {
        return this.result.get() != INCOMPLETE_SENTINEL;
    }

    public T value() {
        if (!this.succeeded()) {
            throw new IllegalStateException("Attempt to retrieve value from future which hasn't successfully completed");
        }
        return (T)this.result.get();
    }

    public boolean succeeded() {
        return this.isDone() && !this.failed();
    }

    public boolean failed() {
        return this.result.get() instanceof RuntimeException;
    }

    public boolean isRetriable() {
        return this.exception() instanceof RetriableException;
    }

    public RuntimeException exception() {
        if (!this.failed()) {
            throw new IllegalStateException("Attempt to retrieve exception from future which hasn't failed");
        }
        return (RuntimeException)this.result.get();
    }

    public void complete(T value) {
        if (value instanceof RuntimeException) {
            throw new IllegalArgumentException("The argument to complete can not be an instance of RuntimeException");
        }
        if (!this.result.compareAndSet(INCOMPLETE_SENTINEL, value)) {
            throw new IllegalStateException("Invalid attempt to complete a request future which is already complete");
        }
        this.fireSuccess();
    }

    public void raise(RuntimeException e) {
        if (e == null) {
            throw new IllegalArgumentException("The exception passed to raise must not be null");
        }
        if (!this.result.compareAndSet(INCOMPLETE_SENTINEL, e)) {
            throw new IllegalStateException("Invalid attempt to complete a request future which is already complete");
        }
        this.fireFailure();
    }

    public void raise(Errors error) {
        this.raise(error.exception());
    }

    private void fireSuccess() {
        RequestFutureListener<T> listener;
        T value = this.value();
        while ((listener = this.listeners.poll()) != null) {
            listener.onSuccess(value);
        }
    }

    private void fireFailure() {
        RequestFutureListener<T> listener;
        RuntimeException exception = this.exception();
        while ((listener = this.listeners.poll()) != null) {
            listener.onFailure(exception);
        }
    }

    public void addListener(RequestFutureListener<T> listener) {
        this.listeners.add(listener);
        if (this.failed()) {
            this.fireFailure();
        } else if (this.succeeded()) {
            this.fireSuccess();
        }
    }

    public <S> RequestFuture<S> compose(final RequestFutureAdapter<T, S> adapter) {
        final RequestFuture<T> adapted = new RequestFuture<T>();
        this.addListener(new RequestFutureListener<T>(){

            @Override
            public void onSuccess(T value) {
                adapter.onSuccess(value, adapted);
            }

            @Override
            public void onFailure(RuntimeException e) {
                adapter.onFailure(e, adapted);
            }
        });
        return adapted;
    }

    public void chain(final RequestFuture<T> future) {
        this.addListener(new RequestFutureListener<T>(){

            @Override
            public void onSuccess(T value) {
                future.complete(value);
            }

            @Override
            public void onFailure(RuntimeException e) {
                future.raise(e);
            }
        });
    }

    public static <T> RequestFuture<T> failure(RuntimeException e) {
        RequestFuture<T> future = new RequestFuture<T>();
        future.raise(e);
        return future;
    }

    public static RequestFuture<Void> voidSuccess() {
        RequestFuture<Void> future = new RequestFuture<Void>();
        future.complete(null);
        return future;
    }

    public static <T> RequestFuture<T> coordinatorNotAvailable() {
        return RequestFuture.failure(Errors.GROUP_COORDINATOR_NOT_AVAILABLE.exception());
    }

    public static <T> RequestFuture<T> leaderNotAvailable() {
        return RequestFuture.failure(Errors.LEADER_NOT_AVAILABLE.exception());
    }

    public static <T> RequestFuture<T> noBrokersAvailable() {
        return RequestFuture.failure(new NoAvailableBrokersException());
    }

    public static <T> RequestFuture<T> staleMetadata() {
        return RequestFuture.failure(new StaleMetadataException());
    }

    @Override
    public boolean shouldBlock() {
        return !this.isDone();
    }
}

