/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Text;

@UDFType(deterministic=false, runtimeConstant=true)
@Description(name="current_group", value="_FUNC_() - Returns all groups the current user belongs to", extended="SessionState GroupsFromAuthenticator")
public class GenericUDFCurrentGroups
extends GenericUDF {
    protected List<Text> currentGroups;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        List<String> sessGroupsFromAuth;
        if (arguments.length != 0) {
            throw new UDFArgumentLengthException("The function CURRENT_GROUPS does not take any arguments, but found " + arguments.length);
        }
        if (this.currentGroups == null && (sessGroupsFromAuth = SessionState.getGroupsFromAuthenticator()) != null) {
            this.currentGroups = new ArrayList<Text>();
            for (String group : sessGroupsFromAuth) {
                this.currentGroups.add(new Text(group));
            }
        }
        return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        return this.currentGroups;
    }

    public List<Text> getCurrentGroups() {
        return this.currentGroups;
    }

    public void setCurrentGroups(List<Text> currentGroups) {
        this.currentGroups = currentGroups;
    }

    @Override
    public String getDisplayString(String[] children) {
        return "CURRENT_GROUPS()";
    }

    @Override
    public void copyToNewInstance(Object newInstance) throws UDFArgumentException {
        super.copyToNewInstance(newInstance);
        GenericUDFCurrentGroups other = (GenericUDFCurrentGroups)newInstance;
        if (this.currentGroups != null && this.currentGroups != null) {
            other.currentGroups = new ArrayList<Text>();
            for (Text group : this.currentGroups) {
                other.currentGroups.add(new Text(group));
            }
        }
    }
}

